/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.impl.publisher;

import eu.maveniverse.maven.mimir.shared.impl.Executors;
import eu.maveniverse.maven.mimir.shared.impl.publisher.PublisherConfig;
import eu.maveniverse.maven.mimir.shared.impl.publisher.PublisherSupport;
import eu.maveniverse.maven.mimir.shared.node.SystemEntry;
import eu.maveniverse.maven.mimir.shared.node.SystemNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public class ServerSocketPublisher
extends PublisherSupport {
    private final ServerSocket serverSocket;
    private final ExecutorService executor;

    public ServerSocketPublisher(SystemNode<?> systemNode, PublisherConfig publisherConfig) throws IOException {
        super(systemNode, publisherConfig);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(publisherConfig.hostPort());
        this.serverSocket = new ServerSocket(inetSocketAddress.getPort(), 50, inetSocketAddress.getAddress());
        this.executor = Executors.executorService();
        Thread serverThread = new Thread(() -> {
            try {
                while (!this.serverSocket.isClosed()) {
                    Socket accepted = this.serverSocket.accept();
                    this.executor.submit(() -> {
                        try (Socket socket = accepted;){
                            byte[] buf = socket.getInputStream().readNBytes(36);
                            OutputStream out = socket.getOutputStream();
                            if (buf.length == 36) {
                                String token = new String(buf, StandardCharsets.UTF_8);
                                Optional<SystemEntry> entry = this.publishedEntry(token);
                                if (entry.isPresent()) {
                                    this.logger.debug("HIT: {} to {}", (Object)token, (Object)socket.getRemoteSocketAddress());
                                    try (InputStream is = entry.orElseThrow().inputStream();){
                                        is.transferTo(out);
                                    }
                                } else {
                                    this.logger.warn("MISS: {} to {}", (Object)token, (Object)socket.getRemoteSocketAddress());
                                }
                            }
                            out.flush();
                        }
                        catch (Exception e) {
                            this.logger.error("Error while serving a client", e);
                        }
                    });
                }
            }
            catch (SocketException accepted) {
            }
            catch (Exception e) {
                this.logger.error("Error while accepting client connection", e);
            }
        });
        serverThread.setDaemon(true);
        this.logger.info("Socket publisher starting at {} -> {}:{}", this.serverSocket.getLocalSocketAddress(), publisherConfig.hostAddress(), this.serverSocket.getLocalPort());
        serverThread.start();
    }

    @Override
    protected URI createHandle(String token) {
        return URI.create("socket://" + this.publisherConfig.hostAddress() + ":" + this.serverSocket.getLocalPort() + "/" + token);
    }

    @Override
    protected void doClose() throws IOException {
        this.logger.info("Socket publisher stopping at {}", (Object)this.serverSocket.getLocalSocketAddress());
        this.executor.shutdown();
        this.serverSocket.close();
    }

    public String toString() {
        return "socket(" + this.publisherConfig.hostAddress() + ":" + this.serverSocket.getLocalPort() + ")";
    }
}

