/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.shared.naming;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.aether.repository.RemoteRepository;

public final class RemoteRepositories {
    public static final String CENTRAL_REPOSITORY_ID = "central";
    private static final Collection<String> CENTRAL_URLS = List.of("https://repo.maven.apache.org/maven2", "https://repo1.maven.org/maven2", "https://maven-central.storage-download.googleapis.com/maven2");

    private RemoteRepositories() {
    }

    public static Predicate<RemoteRepository> centralDirectOnly() {
        return RemoteRepositories.httpsReleaseDirectOnlyWithIds(Collections.singleton(CENTRAL_REPOSITORY_ID)).and(remoteRepository -> CENTRAL_URLS.stream().anyMatch(u -> remoteRepository.getUrl().startsWith((String)u)));
    }

    public static Predicate<RemoteRepository> httpsReleaseDirectOnlyWithIds(Set<String> repositoryIds) {
        Objects.requireNonNull(repositoryIds, "repositoryIds");
        return RemoteRepositories.httpsReleaseDirectOnly().and(remoteRepository -> repositoryIds.contains(remoteRepository.getId()));
    }

    public static Predicate<RemoteRepository> httpsReleaseDirectOnly() {
        return RemoteRepositories.releaseDirectOnly().and(remoteRepository -> remoteRepository.getProtocol().toLowerCase(Locale.ROOT).contains("https"));
    }

    public static Predicate<RemoteRepository> releaseDirectOnly() {
        return remoteRepository -> remoteRepository != null && remoteRepository.getPolicy(false).isEnabled() && !remoteRepository.getPolicy(true).isEnabled() && remoteRepository.getMirroredRepositories().isEmpty() && !remoteRepository.isRepositoryManager() && !remoteRepository.isBlocked();
    }
}

