/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect.df;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.internal.impl.collect.DataPool;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCollectionContext;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCycle;
import org.eclipse.aether.internal.impl.collect.DefaultVersionFilterContext;
import org.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import org.eclipse.aether.internal.impl.collect.PremanagedDependency;
import org.eclipse.aether.internal.impl.collect.df.NodeStack;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.version.Version;

@Singleton
@Named(value="df")
public class DfDependencyCollector
extends DependencyCollectorDelegate
implements Service {
    public static final String NAME = "df";

    @Deprecated
    public DfDependencyCollector() {
    }

    @Inject
    public DfDependencyCollector(RemoteRepositoryManager remoteRepositoryManager, ArtifactDescriptorReader artifactDescriptorReader, VersionRangeResolver versionRangeResolver) {
        super(remoteRepositoryManager, artifactDescriptorReader, versionRangeResolver);
    }

    @Override
    protected void doCollectDependencies(RepositorySystemSession session, RequestTrace trace, DataPool pool, DefaultDependencyCollectionContext context, DefaultVersionFilterContext versionContext, CollectRequest request, DependencyNode node, List<RemoteRepository> repositories, List<Dependency> dependencies, List<Dependency> managedDependencies, DependencyCollectorDelegate.Results results) {
        NodeStack nodes = new NodeStack();
        nodes.push(node);
        Args args2 = new Args(session, pool, nodes, context, versionContext, request);
        this.process(args2, trace, results, dependencies, repositories, session.getDependencySelector() != null ? session.getDependencySelector().deriveChildSelector(context) : null, session.getDependencyManager() != null ? session.getDependencyManager().deriveChildManager(context) : null, session.getDependencyTraverser() != null ? session.getDependencyTraverser().deriveChildTraverser(context) : null, session.getVersionFilter() != null ? session.getVersionFilter().deriveChildFilter(context) : null);
    }

    private void process(Args args2, RequestTrace trace, DependencyCollectorDelegate.Results results, List<Dependency> dependencies, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter) {
        for (Dependency dependency : dependencies) {
            this.processDependency(args2, trace, results, repositories, depSelector, depManager, depTraverser, verFilter, dependency);
        }
    }

    private void processDependency(Args args2, RequestTrace trace, DependencyCollectorDelegate.Results results, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter, Dependency dependency) {
        List<Artifact> relocations = Collections.emptyList();
        this.processDependency(args2, trace, results, repositories, depSelector, depManager, depTraverser, verFilter, dependency, relocations, false);
    }

    private void processDependency(Args args2, RequestTrace parent, DependencyCollectorDelegate.Results results, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter, Dependency dependency, List<Artifact> relocations, boolean disableVersionManagement) {
        List<? extends Version> versions;
        VersionRangeResult rangeResult;
        if (depSelector != null && !depSelector.selectDependency(dependency)) {
            return;
        }
        RequestTrace trace = this.collectStepTrace(parent, args2.request.getRequestContext(), args2.nodes.nodes, dependency);
        PremanagedDependency preManaged = PremanagedDependency.create(depManager, dependency, disableVersionManagement, args2.premanagedState);
        boolean noDescriptor = DfDependencyCollector.isLackingDescriptor((dependency = preManaged.getManagedDependency()).getArtifact());
        boolean traverse = !noDescriptor && (depTraverser == null || depTraverser.traverseDependency(dependency));
        try {
            VersionRangeRequest rangeRequest = DfDependencyCollector.createVersionRangeRequest(args2.request.getRequestContext(), trace, repositories, dependency);
            rangeResult = this.cachedResolveRangeResult(rangeRequest, args2.pool, args2.session);
            versions = DfDependencyCollector.filterVersions(dependency, rangeResult, verFilter, args2.versionContext);
        }
        catch (VersionRangeResolutionException e) {
            results.addException(dependency, e, args2.nodes.nodes);
            return;
        }
        for (Version version : versions) {
            DependencyNode node;
            ArtifactDescriptorRequest descriptorRequest;
            Artifact originalArtifact = dependency.getArtifact().setVersion(version.toString());
            Dependency d = dependency.setArtifact(originalArtifact);
            ArtifactDescriptorResult descriptorResult = this.getArtifactDescriptorResult(args2, results, noDescriptor, d, descriptorRequest = DfDependencyCollector.createArtifactDescriptorRequest(args2.request.getRequestContext(), trace, repositories, d));
            if (descriptorResult != null) {
                DefaultDependencyNode child;
                d = d.setArtifact(descriptorResult.getArtifact());
                node = args2.nodes.top();
                int cycleEntry = DefaultDependencyCycle.find(args2.nodes.nodes, d.getArtifact());
                if (cycleEntry >= 0) {
                    results.addCycle(args2.nodes.nodes, cycleEntry, d);
                    DependencyNode cycleNode = args2.nodes.get(cycleEntry);
                    if (cycleNode.getDependency() != null) {
                        child = DfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult, cycleNode);
                        node.getChildren().add(child);
                        continue;
                    }
                }
                if (!descriptorResult.getRelocations().isEmpty()) {
                    boolean disableVersionManagementSubsequently = originalArtifact.getGroupId().equals(d.getArtifact().getGroupId()) && originalArtifact.getArtifactId().equals(d.getArtifact().getArtifactId());
                    this.processDependency(args2, parent, results, repositories, depSelector, depManager, depTraverser, verFilter, d, descriptorResult.getRelocations(), disableVersionManagementSubsequently);
                    return;
                }
                d = args2.pool.intern(d.setArtifact(args2.pool.intern(d.getArtifact())));
                List<RemoteRepository> repos = DfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), repositories);
                child = DfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult.getAliases(), repos, args2.request.getRequestContext());
                node.getChildren().add(child);
                boolean recurse = traverse && !descriptorResult.getDependencies().isEmpty();
                if (!recurse) continue;
                this.doRecurse(args2, parent, results, repositories, depSelector, depManager, depTraverser, verFilter, d, descriptorResult, child);
                continue;
            }
            node = args2.nodes.top();
            List<RemoteRepository> repos = DfDependencyCollector.getRemoteRepositories(rangeResult.getRepository(version), repositories);
            DefaultDependencyNode child = DfDependencyCollector.createDependencyNode(relocations, preManaged, rangeResult, version, d, null, repos, args2.request.getRequestContext());
            node.getChildren().add(child);
        }
    }

    private void doRecurse(Args args2, RequestTrace trace, DependencyCollectorDelegate.Results results, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, VersionFilter verFilter, Dependency d, ArtifactDescriptorResult descriptorResult, DefaultDependencyNode child) {
        DefaultDependencyCollectionContext context = args2.collectionContext;
        context.set(d, descriptorResult.getManagedDependencies());
        DependencySelector childSelector = depSelector != null ? depSelector.deriveChildSelector(context) : null;
        DependencyManager childManager = depManager != null ? depManager.deriveChildManager(context) : null;
        DependencyTraverser childTraverser = depTraverser != null ? depTraverser.deriveChildTraverser(context) : null;
        VersionFilter childFilter = verFilter != null ? verFilter.deriveChildFilter(context) : null;
        List<RemoteRepository> childRepos = args2.ignoreRepos ? repositories : this.remoteRepositoryManager.aggregateRepositories(args2.session, repositories, descriptorResult.getRepositories(), true);
        Object key = args2.pool.toKey(d.getArtifact(), childRepos, childSelector, childManager, childTraverser, childFilter);
        List<DependencyNode> children = args2.pool.getChildren(key);
        if (children == null) {
            args2.pool.putChildren(key, child.getChildren());
            args2.nodes.push(child);
            this.process(args2, trace, results, descriptorResult.getDependencies(), childRepos, childSelector, childManager, childTraverser, childFilter);
            args2.nodes.pop();
        } else {
            child.setChildren(children);
        }
    }

    private ArtifactDescriptorResult getArtifactDescriptorResult(Args args2, DependencyCollectorDelegate.Results results, boolean noDescriptor, Dependency d, ArtifactDescriptorRequest descriptorRequest) {
        return noDescriptor ? new ArtifactDescriptorResult(descriptorRequest) : this.resolveCachedArtifactDescriptor(args2.pool, descriptorRequest, args2.session, d, results, args2);
    }

    private ArtifactDescriptorResult resolveCachedArtifactDescriptor(DataPool pool, ArtifactDescriptorRequest descriptorRequest, RepositorySystemSession session, Dependency d, DependencyCollectorDelegate.Results results, Args args2) {
        DataPool.DescriptorKey key = pool.toKey(descriptorRequest);
        ArtifactDescriptorResult descriptorResult = pool.getDescriptor(key, descriptorRequest);
        if (descriptorResult == null) {
            try {
                descriptorResult = this.descriptorReader.readArtifactDescriptor(session, descriptorRequest);
                pool.putDescriptor(key, descriptorResult);
            }
            catch (ArtifactDescriptorException e) {
                results.addException(d, e, args2.nodes.nodes);
                pool.putDescriptor(key, e);
                return null;
            }
        } else if (descriptorResult == DataPool.NO_DESCRIPTOR) {
            return null;
        }
        return descriptorResult;
    }

    static class Args {
        final RepositorySystemSession session;
        final boolean ignoreRepos;
        final boolean premanagedState;
        final DataPool pool;
        final NodeStack nodes;
        final DefaultDependencyCollectionContext collectionContext;
        final DefaultVersionFilterContext versionContext;
        final CollectRequest request;

        Args(RepositorySystemSession session, DataPool pool, NodeStack nodes, DefaultDependencyCollectionContext collectionContext, DefaultVersionFilterContext versionContext, CollectRequest request) {
            this.session = session;
            this.request = request;
            this.ignoreRepos = session.isIgnoreArtifactDescriptorRepositories();
            this.premanagedState = ConfigUtils.getBoolean(session, false, "aether.dependencyManager.verbose");
            this.pool = pool;
            this.nodes = nodes;
            this.collectionContext = collectionContext;
            this.versionContext = versionContext;
        }
    }
}

