/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;

public abstract class Request<T>
extends CompletableFuture<T> {
    protected long req_id;
    protected final RequestCorrelator corr;
    protected final RequestOptions options;
    protected long start_time;

    public Request(RequestCorrelator corr, RequestOptions options) {
        this.corr = corr;
        this.options = options;
    }

    public Request<T> requestId(long req_id) {
        this.req_id = req_id;
        return this;
    }

    public long requestId() {
        return this.req_id;
    }

    public Request<T> setResponseFilter(RspFilter filter) {
        this.options.rspFilter(filter);
        return this;
    }

    public T execute(Message msg, boolean block_for_results) throws Exception {
        if (this.corr == null) {
            return null;
        }
        this.sendRequest(msg);
        if (!block_for_results || this.options.mode() == ResponseMode.GET_NONE) {
            return null;
        }
        long timeout2 = this.options.timeout();
        return timeout2 > 0L ? this.waitForCompletion(timeout2, TimeUnit.MILLISECONDS) : this.waitForCompletion();
    }

    public abstract void sendRequest(Message var1) throws Exception;

    public abstract void receiveResponse(Object var1, Address var2, boolean var3);

    public abstract void viewChange(View var1, boolean var2);

    public abstract void siteUnreachable(String var1);

    public abstract void memberUnreachable(Address var1);

    public abstract void transportClosed();

    public abstract T waitForCompletion(long var1, TimeUnit var3) throws Exception;

    public abstract T waitForCompletion() throws Exception;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            boolean bl = super.cancel(mayInterruptIfRunning);
            return bl;
        }
        finally {
            this.corrDone();
        }
    }

    @Override
    public String toString() {
        return String.format("%s, mode=%s", new Object[]{this.getClass().getSimpleName(), this.options.mode()});
    }

    protected void corrDone() {
        if (this.corr != null && this.req_id > 0L) {
            this.corr.done(this.req_id);
        }
    }
}

