/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.View;

public class Topology
extends Frame
implements WindowListener {
    private final List<Address> members = new ArrayList<Address>();
    private final Font myFont;
    private final FontMetrics fm;
    private final Color node_color = new Color(250, 220, 100);
    private boolean coordinator = false;
    private static final int NormalStyle = 0;
    private static final int CheckStyle = 1;
    private JChannel channel;
    private Object my_addr = null;
    private String props = "udp.xml";
    private final String name;
    private static final String channel_name = "FD-Heartbeat";

    public Topology(String props, String name) {
        this.props = props;
        this.name = name;
        this.addWindowListener(this);
        this.fm = this.getFontMetrics(new Font("Helvetica", 0, 12));
        this.myFont = new Font("Helvetica", 0, 12);
    }

    public void addNode(Address member) {
        for (int i = 0; i < this.members.size(); ++i) {
            Address tmp = this.members.get(i);
            if (!member.equals(tmp)) continue;
            return;
        }
        this.members.add(member);
        this.repaint();
    }

    public void removeNode(Object member) {
        for (int i = 0; i < this.members.size(); ++i) {
            Address tmp = this.members.get(i);
            if (!member.equals(tmp)) continue;
            this.members.remove(this.members.get(i));
            break;
        }
        this.repaint();
    }

    public void drawNode(Graphics g, int x, int y, String label, int style) {
        Color old = g.getColor();
        int width = this.fm.stringWidth(label) + 10;
        int height = this.fm.getHeight() + 5;
        g.setColor(this.node_color);
        g.fillRect(x, y, width, height);
        g.setColor(old);
        g.drawString(label, x + 5, y + 15);
        g.drawRoundRect(x - 1, y - 1, width + 1, height + 1, 10, 10);
        if (style == 1) {
            g.drawRoundRect(x - 2, y - 2, width + 2, height + 2, 10, 10);
            g.drawRoundRect(x - 3, y - 3, width + 3, height + 3, 10, 10);
        }
    }

    public void drawTopology(Graphics g) {
        int x = 20;
        int y = 50;
        Dimension box = this.getSize();
        Color old = g.getColor();
        if (this.coordinator) {
            g.setColor(Color.cyan);
            g.fillRect(11, 31, box.width - 21, box.height - 61);
            g.setColor(old);
        }
        g.drawRect(10, 30, box.width - 20, box.height - 60);
        g.setFont(this.myFont);
        for (int i = 0; i < this.members.size(); ++i) {
            String label = this.members.get(i).toString();
            this.drawNode(g, x, y, label, 0);
            y += 50;
        }
    }

    @Override
    public void paint(Graphics g) {
        this.drawTopology(g);
    }

    public void coordinatorChosen() {
        this.coordinator = true;
        this.repaint();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        this.dispose();
        this.channel.close();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public void start() throws Exception {
        this.channel = new JChannel(this.props).name(this.name);
        this.channel.setReceiver(new Receiver(){

            @Override
            public void viewAccepted(View view) {
                this.setInternalState(view.getMembers());
            }

            public void setInternalState(List<Address> mbrs) {
                Topology.this.members.clear();
                for (Address mbr : mbrs) {
                    Topology.this.addNode(mbr);
                }
                Topology.this.coordinator = mbrs.size() <= 1 || mbrs.size() > 1 && mbrs.iterator().next().equals(Topology.this.my_addr);
                Topology.this.repaint();
            }
        });
        this.channel.connect(channel_name);
        this.my_addr = this.channel.getAddress();
        if (this.my_addr != null) {
            this.setTitle(this.my_addr.toString());
        }
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] args2) {
        String name = null;
        String props = "udp.xml";
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].equals("-name")) {
                name = args2[++i];
                continue;
            }
            if (args2[i].equals("-props")) {
                props = args2[++i];
                continue;
            }
            System.out.println("Topology [-props config file] [-name name]");
            return;
        }
        try {
            Topology top = new Topology(props, name);
            top.setLayout(null);
            top.setSize(240, 507);
            top.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }
}

