/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.Closeable;
import java.util.Collection;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Component;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.cs.TcpServer;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.BasicTCP;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.TLS;
import org.jgroups.util.Util;

public class TCP
extends BasicTCP {
    protected TcpServer srv;
    @Property(description="Size of the buffer of the BufferedInputStream in TcpConnection. A read always tries to read ahead as much data as possible into the buffer. 0: default size", type=AttributeType.BYTES)
    protected int buffered_input_stream_size = 65536;
    @Property(description="Size of the buffer of the BufferedOutputStream in TcpConnection. Smaller messages are  buffered until this size is exceeded or flush() is called. Bigger messages are sent immediately. 0: default size", type=AttributeType.BYTES)
    protected int buffered_output_stream_size = 65536;
    @Property(description="Log a warning (or not) when ServerSocket.accept() throws an exception")
    protected boolean log_accept_error = true;
    @Component(name="tls", description="Contains the attributes for TLS (SSL sockets) when enabled=true")
    protected TLS tls = new TLS();
    @Property(description="use bounded queues for sending (https://issues.redhat.com/browse/JGRP-2759)")
    protected boolean non_blocking_sends;
    @Property(description="when sending and non_blocking, how many messages to queue max")
    protected int max_send_queue = 128;

    public int getBufferedInputStreamSize() {
        return this.buffered_input_stream_size;
    }

    public TCP setBufferedInputStreamSize(int buffered_input_stream_size) {
        this.buffered_input_stream_size = buffered_input_stream_size;
        return this;
    }

    public int getBufferedOutputStreamSize() {
        return this.buffered_output_stream_size;
    }

    public TCP setBufferedOutputStreamSize(int buffered_output_stream_size) {
        this.buffered_output_stream_size = buffered_output_stream_size;
        return this;
    }

    public TLS tls() {
        return this.tls;
    }

    public TCP tls(TLS t) {
        this.tls = t;
        return this;
    }

    public boolean logAcceptError() {
        return this.log_accept_error;
    }

    public TCP logAcceptError(boolean l) {
        this.log_accept_error = l;
        if (this.srv != null) {
            this.srv.setLogAcceptError(l);
        }
        return this;
    }

    public boolean nonBlockingSends() {
        return this.non_blocking_sends;
    }

    public TCP nonBlockingSends(boolean b) {
        this.non_blocking_sends = b;
        return this;
    }

    public int maxSendQueue() {
        return this.max_send_queue;
    }

    public TCP maxSendQueue(int s) {
        this.max_send_queue = s;
        return this;
    }

    @ManagedAttribute
    public int getOpenConnections() {
        return this.srv.getNumConnections();
    }

    @Override
    @ManagedOperation
    public String printConnections() {
        return this.srv.printConnections();
    }

    @ManagedOperation(description="Clears all connections (they will get re-established). For testing only, don't use !")
    public TCP clearConnections() {
        this.srv.clearConnections();
        return this;
    }

    @Override
    public void setSocketFactory(SocketFactory factory2) {
        super.setSocketFactory(factory2);
        if (this.srv != null) {
            this.srv.socketFactory(factory2);
        }
    }

    @Override
    public void send(Address dest, byte[] data, int offset, int length) throws Exception {
        if (this.srv != null) {
            this.srv.send(dest, data, offset, length);
        }
    }

    @Override
    public void retainAll(Collection<Address> members) {
        this.srv.retainAll(members);
    }

    @Override
    public void start() throws Exception {
        if (this.tls.enabled()) {
            SocketFactory factory2 = this.tls.createSocketFactory();
            this.setSocketFactory(factory2);
        }
        this.srv = new TcpServer(this.getThreadFactory(), this.getSocketFactory(), this.bind_addr, this.bind_port, this.bind_port + this.port_range, this.external_addr, this.external_port, this.recv_buf_size).setLogAcceptError(this.log_accept_error);
        this.srv.setBufferedInputStreamSize(this.buffered_input_stream_size).setBufferedOutputStreamSize(this.buffered_output_stream_size).peerAddressReadTimeout(this.peer_addr_read_timeout).nonBlockingSends(this.non_blocking_sends).maxSendQueue(this.max_send_queue).usePeerConnections(true).socketFactory(this.getSocketFactory()).receiver(this).timeService(this.time_service).socketConnectionTimeout(this.sock_conn_timeout).tcpNodelay(this.tcp_nodelay).linger(this.linger).clientBindAddress(this.client_bind_addr).clientBindPort(this.client_bind_port).deferClientBinding(this.defer_client_bind_addr).log(this.log).logDetails(this.log_details).addConnectionListener(this);
        if (this.send_buf_size > 0) {
            this.srv.sendBufferSize(this.send_buf_size);
        }
        if (this.recv_buf_size > 0) {
            this.srv.receiveBufferSize(this.recv_buf_size);
        }
        if (this.reaper_interval > 0L || this.conn_expire_time > 0L) {
            if (this.reaper_interval == 0L) {
                this.reaper_interval = 5000L;
                this.log.warn("reaper_interval was 0, set it to %d", this.reaper_interval);
            }
            if (this.conn_expire_time == 0L) {
                this.conn_expire_time = 300000L;
                this.log.warn("conn_expire_time was 0, set it to %d", this.conn_expire_time);
            }
            this.srv.connExpireTimeout(this.conn_expire_time).reaperInterval(this.reaper_interval);
        }
        if (this.max_length > 0) {
            this.srv.setMaxLength(this.max_length);
        }
        super.start();
    }

    @Override
    public void stop() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("%s: closing sockets and stopping threads", this.local_addr);
        }
        super.stop();
        Util.close((Closeable)this.srv);
    }

    @Override
    protected void handleConnect() throws Exception {
        this.srv.start();
    }

    @Override
    protected void handleDisconnect() {
        this.srv.stop();
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.srv != null ? (PhysicalAddress)this.srv.localAddress() : null;
    }
}

