/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jgroups.JChannel;
import org.jgroups.JChannelProbeHandler;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.jmx.ResourceDMBean;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class NonReflectiveProbeHandler
extends JChannelProbeHandler {
    protected final Map<String, Map<String, ResourceDMBean.Accessor>> attrs = new LinkedHashMap<String, Map<String, ResourceDMBean.Accessor>>();
    protected final Map<String, Map<String, ResourceDMBean.Accessor>> setters = new LinkedHashMap<String, Map<String, ResourceDMBean.Accessor>>();
    protected final Map<String, Map<String, ResourceDMBean.MethodAccessor>> operations = new LinkedHashMap<String, Map<String, ResourceDMBean.MethodAccessor>>();
    protected static final Predicate<AccessibleObject> FILTER = obj -> obj.isAnnotationPresent(ManagedAttribute.class) || obj.isAnnotationPresent(Property.class) && obj.getAnnotation(Property.class).exposeAsManagedAttribute() || obj.isAnnotationPresent(ManagedOperation.class);

    public NonReflectiveProbeHandler(JChannel ch) {
        super(ch);
    }

    public NonReflectiveProbeHandler initialize(Protocol[] protocols) {
        return this.initialize(Arrays.asList(protocols));
    }

    public NonReflectiveProbeHandler initialize(Collection<Protocol> prots) {
        for (Protocol prot : prots) {
            String prot_name = prot.getName();
            Map m = this.attrs.computeIfAbsent(prot_name, k -> new TreeMap());
            BiConsumer<Field, Object> field_func = (f, o) -> m.put(f.getName(), new ResourceDMBean.FieldAccessor((Field)f, o));
            BiConsumer<Method, Object> method_func = (method, obj) -> {
                if (method.isAnnotationPresent(ManagedOperation.class)) {
                    Map tmp = this.operations.computeIfAbsent(prot_name, k -> new TreeMap());
                    tmp.put(method.getName(), new ResourceDMBean.MethodAccessor((Method)method, obj));
                } else if (ResourceDMBean.isGetMethod(method)) {
                    String method_name = Util.getNameFromAnnotation(method);
                    String attributeName = Util.methodNameToAttributeName(method_name);
                    m.put(attributeName, new ResourceDMBean.MethodAccessor((Method)method, obj));
                } else if (ResourceDMBean.isSetMethod(method)) {
                    Map tmp = this.setters.computeIfAbsent(prot_name, k -> new TreeMap());
                    String method_name = Util.getNameFromAnnotation(method);
                    String attributeName = Util.methodNameToAttributeName(method_name);
                    tmp.put(attributeName, new ResourceDMBean.MethodAccessor((Method)method, obj));
                }
            };
            Util.forAllFieldsAndMethods(prot, FILTER, field_func, method_func);
            List<Object> objects = prot.getComponents();
            if (objects == null) continue;
            for (Object obj2 : objects) {
                if (obj2 == null) continue;
                Util.forAllFieldsAndMethods(obj2, FILTER, field_func, method_func);
            }
        }
        return this;
    }

    public String dump() {
        Map<String, ResourceDMBean.Accessor> val;
        StringBuilder sb = new StringBuilder("attrs\n-----\n");
        for (Map.Entry<String, Map<String, ResourceDMBean.Accessor>> entry : this.attrs.entrySet()) {
            sb.append(entry.getKey() + ":\n");
            val = entry.getValue();
            val.forEach((key, value) -> sb.append(key + ": " + value).append("\n"));
        }
        sb.append("\nsetters\n--------\n");
        for (Map.Entry<String, Map<String, ResourceDMBean.Accessor>> entry : this.setters.entrySet()) {
            sb.append(entry.getKey() + ":\n");
            val = entry.getValue();
            val.forEach((key, value) -> sb.append(key + ": " + value).append("\n"));
        }
        sb.append("\n");
        sb.append("\noperations\n--------\n");
        for (Map.Entry<String, Map<String, ResourceDMBean.Accessor>> entry : this.operations.entrySet()) {
            sb.append(entry.getKey() + ":\n");
            val = entry.getValue();
            val.forEach((key, value) -> sb.append(key + ": " + value).append("\n"));
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    protected Map<String, Map<String, Object>> dumpAttrsAllProtocols() {
        HashMap<String, Map<String, Object>> retval = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, ResourceDMBean.Accessor>> e : this.attrs.entrySet()) {
            String protocol_name = e.getKey();
            Map<String, ResourceDMBean.Accessor> val = e.getValue();
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (Map.Entry<String, ResourceDMBean.Accessor> en : val.entrySet()) {
                try {
                    Object v = en.getValue().invoke(null);
                    if (v instanceof Double) {
                        v = String.format("%.2f", v);
                    }
                    map.put(en.getKey(), v != null ? v.toString() : "null");
                }
                catch (Exception ex) {
                    this.log.error("failed getting value for attribute %s.%s: %s", protocol_name, en.getKey(), ex);
                }
            }
            if (map.isEmpty()) continue;
            retval.put(protocol_name, map);
        }
        return retval;
    }

    @Override
    protected Map<String, Map<String, Object>> dumpAttrsSelectedProtocol(String protocol_name, List<String> attrs) {
        Map<String, ResourceDMBean.Accessor> map = this.attrs.get(protocol_name);
        if (map == null) {
            return null;
        }
        HashMap<String, Map<String, Object>> retval = new HashMap<String, Map<String, Object>>();
        TreeMap<String, Object> tmp = new TreeMap<String, Object>();
        retval.put(protocol_name, tmp);
        for (Map.Entry<String, ResourceDMBean.Accessor> e : map.entrySet()) {
            String attr_name = e.getKey();
            if (attrs != null) {
                if (!attrs.stream().anyMatch(attr_name::startsWith)) continue;
            }
            try {
                Object v = e.getValue().invoke(null);
                tmp.put(attr_name, v);
            }
            catch (Exception ex) {
                this.log.error("failed getting value for attribute %s.%s: %s", protocol_name, attr_name, ex);
            }
        }
        return retval;
    }

    @Override
    protected void handleAttrWrite(String protocol_name, String attr_name, String attr_value) {
        ResourceDMBean.Accessor setter;
        Object converted_value = null;
        Map<String, ResourceDMBean.Accessor> m = this.setters.get(protocol_name);
        if (m != null && (setter = m.get(attr_name)) != null) {
            Class<?> type = ((ResourceDMBean.MethodAccessor)setter).getMethod().getParameterTypes()[0];
            converted_value = Util.convert(attr_value, type, null);
            NonReflectiveProbeHandler.invoke(protocol_name, setter, attr_name, converted_value);
            return;
        }
        m = this.attrs.get(protocol_name);
        if (m == null) {
            throw new RuntimeException(String.format("protocol %s not found", protocol_name));
        }
        setter = m.get(attr_name);
        if (setter == null) {
            throw new RuntimeException(String.format("attribute %s not found in protocol %s", attr_name, protocol_name));
        }
        if (setter instanceof ResourceDMBean.FieldAccessor) {
            converted_value = Util.convert(attr_value, ((ResourceDMBean.FieldAccessor)setter).getField().getType(), null);
            NonReflectiveProbeHandler.invoke(protocol_name, setter, attr_name, converted_value);
        }
    }

    @Override
    protected Method findMethod(Protocol prot, String method_name, String[] args2) throws Exception {
        Map<String, ResourceDMBean.MethodAccessor> map = this.operations.get(prot.getName());
        if (map == null) {
            this.log.error("protocol %s not found for method %s", prot.getName(), method_name);
            return null;
        }
        ResourceDMBean.MethodAccessor accessor = map.get(method_name);
        if (accessor == null) {
            this.log.error("method %s not found", method_name);
            return null;
        }
        return accessor.getMethod();
    }

    protected static void invoke(String protocol_name, ResourceDMBean.Accessor setter, String attr, Object value) {
        try {
            setter.invoke(value);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("setting %s=%s failed in protocol %s: %s", attr, value, protocol_name, e));
        }
    }
}

