/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import java.net.SocketException;
import org.jgroups.util.Util;

public class BufferSizeTest {
    protected static void start(int size) throws IOException {
        MulticastSocket mcast_sock = new MulticastSocket();
        BufferSizeTest.setBufferSize(mcast_sock, size, true);
        BufferSizeTest.setBufferSize(mcast_sock, size, false);
        DatagramSocket sock = new DatagramSocket();
        BufferSizeTest.setBufferSize(sock, size, true);
        BufferSizeTest.setBufferSize(sock, size, false);
    }

    protected static void setBufferSize(DatagramSocket sock, int size, boolean recv_buf) throws SocketException {
        int new_size;
        int prev_size;
        int n = prev_size = recv_buf ? sock.getReceiveBufferSize() : sock.getSendBufferSize();
        if (recv_buf) {
            sock.setReceiveBufferSize(size);
        } else {
            sock.setSendBufferSize(size);
        }
        int n2 = new_size = recv_buf ? sock.getReceiveBufferSize() : sock.getSendBufferSize();
        if (new_size == size) {
            System.out.printf("-- %s OK: set %s buffer from %s to %s\n", sock.getClass().getSimpleName(), recv_buf ? "recv" : "send", Util.printBytes(prev_size), Util.printBytes(size));
        } else {
            System.err.printf("-- %s FAIL: set %s buffer from %s to %s (actual size: %s)\n", sock.getClass().getSimpleName(), recv_buf ? "recv" : "send", Util.printBytes(prev_size), Util.printBytes(size), Util.printBytes(new_size));
        }
    }

    public static void main(String[] args2) throws IOException {
        int size = 50000000;
        for (int i = 0; i < args2.length; ++i) {
            if (!"-size".equals(args2[i])) {
                BufferSizeTest.help();
                return;
            }
            size = Integer.parseInt(args2[++i]);
        }
        BufferSizeTest.start(size);
    }

    protected static void help() {
        System.out.printf("%s [-size <buffer size in bytes>]\n", BufferSizeTest.class.getSimpleName());
    }
}

