/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import org.jgroups.protocols.PingData;
import org.jgroups.stack.RouterStub;
import org.jgroups.util.Promise;

public class RouterStubGet
implements RouterStub.MembersNotification {
    protected RouterStub stub;
    protected Promise<Void> promise = new Promise();
    protected int cnt = 1;

    protected void start(String host, int port, String cluster_name, boolean nio, long timeout2) {
        try {
            InetSocketAddress local = new InetSocketAddress((InetAddress)null, 0);
            InetSocketAddress remote = new InetSocketAddress(host, port);
            this.stub = new RouterStub(local, remote, nio, null, null);
            this.stub.connect();
            this.stub.getMembers(cluster_name, this);
            this.promise.getResult(timeout2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.stub.destroy();
        }
    }

    @Override
    public void members(String group, List<PingData> mbrs, boolean last) {
        for (PingData data : mbrs) {
            if (group != null) {
                System.out.printf("%d: %s: %s\n", this.cnt++, group, data);
                continue;
            }
            System.out.printf("%d: %s\n", this.cnt++, data);
        }
        if (last) {
            if (this.stub != null) {
                this.stub.destroy();
            }
            this.promise.setResult(null);
        }
    }

    @Override
    public void members(List<PingData> mbrs) {
        this.members(null, mbrs, false);
    }

    public static void main(String[] args2) {
        String host = "localhost";
        String cluster_name = null;
        int port = 12001;
        long timeout2 = 500L;
        boolean nio = true;
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].equals("-host")) {
                host = args2[++i];
                continue;
            }
            if (args2[i].equals("-port")) {
                port = Integer.parseInt(args2[++i]);
                continue;
            }
            if (args2[i].equals("-cluster")) {
                cluster_name = args2[++i];
                continue;
            }
            if (args2[i].equals("-nio")) {
                nio = Boolean.parseBoolean(args2[++i]);
                continue;
            }
            if ("-timeout".equals(args2[i])) {
                timeout2 = Long.parseLong(args2[++i]);
                continue;
            }
            RouterStubGet.help();
            return;
        }
        RouterStubGet get2 = new RouterStubGet();
        get2.start(host, port, cluster_name, nio, timeout2);
    }

    private static void help() {
        System.out.println("RouterStubGet [-host <host>] [-port <port>] [-cluster <cluster name (default: draw>] [-nio true|false] [-timeout <msecs>]");
    }
}

