/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.lang.reflect.Method;
import javax.management.MBeanServer;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Average;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcherSpeedTest
implements Receiver {
    protected JChannel channel;
    protected RpcDispatcher disp;
    protected String props;
    protected boolean jmx;
    protected int num = 5000;
    protected static final Method[] METHODS = new Method[1];
    protected boolean oob;
    protected boolean dont_bundle;
    protected static final String format = "[1] invoke RPCs [2] num (%d) [o] oob (%b) [b] dont_bundle (%b) [x] exit\n";

    public static void measure() {
    }

    public void start(String props, boolean jmx, String name) throws Exception {
        this.channel = new JChannel(props).name(name);
        this.disp = new RpcDispatcher(this.channel, this).setReceiver(this).setMethodLookup(id -> METHODS[0]);
        if (jmx) {
            MBeanServer srv = Util.getMBeanServer();
            if (srv == null) {
                throw new Exception("No MBeanServers found");
            }
            JmxConfigurator.registerChannel(this.channel, srv, "jgroups", this.channel.getClusterName(), true);
        }
        this.channel.connect("rpc-speed-test");
        View view = this.channel.getView();
        if (view.size() > 2) {
            System.err.printf("More than 2 members in cluster: %s; terminating\n", view);
        } else {
            this.loop();
        }
        Util.close(this.disp, this.channel);
    }

    protected void loop() {
        boolean looping = true;
        while (looping) {
            try {
                int c = Util.keyPress(String.format(format, this.num, this.oob, this.dont_bundle));
                switch (c) {
                    case 49: {
                        this.invokeRpcs();
                        break;
                    }
                    case 50: {
                        this.num = Util.readIntFromStdin("num: ");
                        break;
                    }
                    case 111: {
                        this.oob = !this.oob;
                        break;
                    }
                    case 98: {
                        this.dont_bundle = !this.dont_bundle;
                        break;
                    }
                    case -1: 
                    case 120: {
                        looping = false;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void invokeRpcs() throws Exception {
        Average avg = new Average();
        long min = Long.MAX_VALUE;
        long max = 0L;
        RequestOptions opts = new RequestOptions(ResponseMode.GET_FIRST, 0L).transientFlags(Message.TransientFlag.DONT_LOOPBACK);
        MethodCall call = new MethodCall(0, new Object[0]);
        int print = this.num / 10;
        if (this.oob) {
            opts.flags(Message.Flag.OOB);
        }
        if (this.dont_bundle) {
            opts.flags(Message.Flag.DONT_BUNDLE);
        }
        if (this.channel.getView().size() != 2) {
            System.err.printf("Cluster must have exactly 2 members: %s\n", this.channel.getView());
            return;
        }
        System.out.printf("\nInvoking %d blocking RPCs (oob: %b, dont_bundle: %b)\n", this.num, this.oob, this.dont_bundle);
        for (int i = 0; i < this.num; ++i) {
            boolean all_received;
            long start = System.nanoTime();
            RspList rsps = this.disp.callRemoteMethods(null, call, opts);
            long time_ns = System.nanoTime() - start;
            if (i > 0 && i % print == 0) {
                System.out.print(".");
            }
            if (!(all_received = rsps.values().stream().allMatch(Rsp::wasReceived))) {
                System.err.printf("didn't receive all responses: %s\n", rsps);
            }
            avg.add(time_ns);
            min = Math.min(min, time_ns);
            max = Math.max(max, time_ns);
        }
        System.out.println("");
        System.out.printf("\nround-trip = min/avg/max: %.2f / %.2f / %.2f us\n\n", (double)min / 1000.0, avg.average() / 1000.0, (double)max / 1000.0);
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("-- new view: " + new_view);
    }

    public static void main(String[] args2) throws Exception {
        String props = null;
        String name = null;
        boolean jmx = false;
        for (int i = 0; i < args2.length; ++i) {
            if ("-props".equals(args2[i])) {
                props = args2[++i];
                continue;
            }
            if ("-jmx".equals(args2[i])) {
                jmx = true;
                continue;
            }
            if ("-name".equals(args2[i])) {
                name = args2[++i];
                continue;
            }
            RpcDispatcherSpeedTest.help();
            return;
        }
        RpcDispatcherSpeedTest test = new RpcDispatcherSpeedTest();
        test.start(props, jmx, name);
    }

    static void help() {
        System.out.println("RpcDispatcherSpeedTest [-help] [-props <props>] [-name name] [-jmx]");
    }

    static {
        try {
            RpcDispatcherSpeedTest.METHODS[0] = RpcDispatcherSpeedTest.class.getMethod("measure", new Class[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

