/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.jgroups.util.Util;

public class GenerateProfilingScript {
    protected int num_rules_generated;
    protected static final String PREFIX = "# Byteman script to profile individual methods\n\n\nRULE DiagnosticHandler creation\nCLASS ^TP\nHELPER org.jgroups.util.ProfilingHelper\nMETHOD handleConnect()\nAT ENTRY\nBIND tp=$this, diag=tp.getDiagnosticsHandler();\nIF TRUE\n   DO diagCreated(diag);\nENDRULE\n\n";
    protected static final String START_RULE = "RULE %s start\n%s %s\nHELPER org.jgroups.util.ProfilingHelper\nMETHOD %s\nCOMPILE\nAT ENTRY\nIF TRUE\n   DO start(\"%s\");\nENDRULE\n\n";
    protected static final String STOP_RULE = "RULE %s stop\n%s %s\nHELPER org.jgroups.util.ProfilingHelper\nMETHOD %s\nCOMPILE\nAT EXIT\nIF TRUE\n   DO stop(\"%s\");\nENDRULE\n\n";

    protected void generate(String input_file, String output_file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(output_file);
             Stream<String> lines = Files.lines(Path.of(input_file, new String[0]));){
            ((OutputStream)out).write(PREFIX.getBytes());
            lines.filter(l -> !l.trim().isEmpty()).forEach(l -> this.generateRule((String)l, out));
        }
    }

    protected void generateRule(String method, OutputStream out) {
        int index = method.lastIndexOf(46);
        if (index < 0) {
            throw new IllegalArgumentException(String.format("method name not found in %s", method));
        }
        String classname = method.substring(0, index).trim();
        String method_name = method.substring(index + 1).trim();
        try {
            Class<?> clazz = Util.loadClass(classname, (Class)null);
            boolean is_interface = clazz.isInterface();
            String start_rule = String.format(START_RULE, clazz.getSimpleName() + "." + method_name, is_interface ? "INTERFACE" : "CLASS", classname, method_name, clazz.getSimpleName() + "." + method_name);
            String stop_rule = String.format(STOP_RULE, clazz.getSimpleName() + "." + method_name, is_interface ? "INTERFACE" : "CLASS", classname, method_name, clazz.getSimpleName() + "." + method_name);
            out.write(start_rule.getBytes());
            out.write(stop_rule.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args2) throws IOException {
        if (args2.length != 2) {
            System.err.printf("%s <input file> <output file>\n", GenerateProfilingScript.class.getSimpleName());
            return;
        }
        String input = args2[0];
        String output = args2[1];
        GenerateProfilingScript tmp = new GenerateProfilingScript();
        tmp.generate(input, output);
    }
}

