/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.SecurityActions;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;

public final class ResourceManager {
    private static final IpAddressRep rep;
    private static short mcast_port;
    private static int tcp_port;
    private static final SocketFactory socket_factory;

    private ResourceManager() {
    }

    public static String getNextMulticastAddress() {
        return rep.nextAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized short getNextMulticastPort(InetAddress bind_addr) throws Exception {
        short port = mcast_port;
        try {
            DatagramSocket sock = Util.createDatagramSocket(socket_factory, "jgroups.temp.resourcemgr.mcast_sock", bind_addr, port);
            port = (short)sock.getLocalPort();
            socket_factory.close(sock);
            short s = port;
            return s;
        }
        finally {
            mcast_port = (short)(port + 1);
        }
    }

    public static synchronized List<Integer> getNextTcpPorts(InetAddress bind_addr, int num_requested_ports) throws Exception {
        int port = tcp_port++;
        ArrayList<Integer> retval = new ArrayList<Integer>(num_requested_ports);
        for (int i = 0; i < num_requested_ports; ++i) {
            port = ResourceManager.getNextTCPPort(bind_addr, port);
            retval.add(port);
            tcp_port = ++port;
        }
        return retval;
    }

    public static synchronized int getNextTcpPort(InetAddress bind_addr) throws Exception {
        int port = tcp_port++;
        try {
            int n = ResourceManager.getNextTCPPort(bind_addr, port);
            return n;
        }
        finally {
            tcp_port = ++port;
        }
    }

    private static int getNextTCPPort(InetAddress bind_addr, int start_port) throws Exception {
        try (ServerSocket sock = new ServerSocket();){
            sock.setReuseAddress(false);
            Util.bind(sock, bind_addr, start_port, start_port + 100);
            int n = sock.getLocalPort();
            return n;
        }
    }

    public static void main(String[] args2) throws Exception {
        List<Integer> ports = ResourceManager.getNextTcpPorts(InetAddress.getByName("192.168.1.3"), 15);
        System.out.println("ports = " + ports);
        ports = ResourceManager.getNextTcpPorts(InetAddress.getByName("192.168.1.3"), 5);
        System.out.println("ports = " + ports);
    }

    static {
        socket_factory = new DefaultSocketFactory();
        StackType type = Util.getIpStackType();
        String tmp_addr = SecurityActions.getProperty("INITIAL_MCAST_ADDR", type == StackType.IPv6 ? "ff0e::9:9:9" : "224.8.8.8");
        mcast_port = Short.parseShort(SecurityActions.getProperty("INITIAL_MCAST_PORT", "7000"));
        tcp_port = Short.parseShort(SecurityActions.getProperty("INITIAL_TCP_PORT", "10000"));
        try {
            InetAddress tmp = InetAddress.getByName(tmp_addr);
            if (!tmp.isMulticastAddress()) {
                throw new IllegalArgumentException("initial multicast address " + tmp_addr + " is not a valid multicast address");
            }
            rep = tmp instanceof Inet4Address ? new IPv4AddressRep(tmp_addr) : new IPv6AddressRep(tmp_addr);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("initial multicast address " + tmp_addr + " is incorrect", e);
        }
    }

    static class IPv6AddressRep
    implements IpAddressRep {
        byte[] bv = null;
        InetAddress address = null;
        private static boolean carry = false;

        IPv6AddressRep(String initial_addr) {
            try {
                this.address = InetAddress.getByName(initial_addr);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Multicast address " + initial_addr + " has incorrect format", e);
            }
            catch (SecurityException e) {
                throw new RuntimeException("Security violation in accessing multicast address " + initial_addr, e);
            }
            this.bv = this.address.getAddress();
        }

        @Override
        public synchronized String nextAddress() {
            try {
                this.address = InetAddress.getByAddress(this.bv);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Multicast address has incorrect length", e);
            }
            this.increment();
            String addressWithHostname = this.address.toString();
            return addressWithHostname.substring(addressWithHostname.indexOf(47) + 1);
        }

        private void increment() {
            for (int i = this.bv.length - 1; i >= 0; --i) {
                this.bv[i] = IPv6AddressRep.incrementHexValue(this.bv[i]);
                if (!carry) {
                    return;
                }
                carry = false;
            }
            throw new RuntimeException("Cannot increment multicast address ");
        }

        private static byte incrementHexValue(byte b) {
            if (b >= 0 && b < 127) {
                return (byte)(b + 1);
            }
            if (b == 127) {
                return -128;
            }
            if (b >= -128 && b < -1) {
                return (byte)(b + 1);
            }
            if (b == -1) {
                carry = true;
                return 0;
            }
            return 0;
        }
    }

    static class IPv4AddressRep
    implements IpAddressRep {
        short a = (short)225;
        short b = 1;
        short c = 1;
        short d = 1;
        private static final short MIN = 1;
        private static final short MAX = 250;
        private static final char DOT = '.';

        IPv4AddressRep(String initial_addr) {
            StringTokenizer tok = new StringTokenizer(initial_addr, ".", false);
            this.a = Short.parseShort(tok.nextToken());
            this.b = Short.parseShort(tok.nextToken());
            this.c = Short.parseShort(tok.nextToken());
            this.d = Short.parseShort(tok.nextToken());
        }

        @Override
        public synchronized String nextAddress() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.a).append('.').append(this.b).append('.').append(this.c).append('.').append(this.d);
            this.increment();
            return sb.toString();
        }

        private void increment() {
            this.d = (short)(this.d + 1);
            if (this.d > 250) {
                this.d = 1;
                this.c = (short)(this.c + 1);
                if (this.c > 250) {
                    this.c = 1;
                    this.b = (short)(this.b + 1);
                    if (this.b > 250) {
                        this.b = 1;
                        this.a = (short)(this.a + 1);
                        if (this.a > 250) {
                            this.a = (short)225;
                        }
                    }
                }
            }
        }
    }

    public static interface IpAddressRep {
        public String nextAddress();
    }
}

