/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.extension3;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithm;

public class ChecksumCalculator {
    private final Map<String, ChecksumAlgorithm> checksumAlgorithms;

    public ChecksumCalculator(Map<String, ChecksumAlgorithm> checksumAlgorithms) {
        this.checksumAlgorithms = Objects.requireNonNull(checksumAlgorithms, "checksumAlgorithms");
    }

    public void update(ByteBuffer buffer) {
        for (ChecksumAlgorithm checksum : this.checksumAlgorithms.values()) {
            ((Buffer)buffer).mark();
            checksum.update(buffer);
            ((Buffer)buffer).reset();
        }
    }

    public Map<String, String> getChecksums() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, ChecksumAlgorithm> entry : this.checksumAlgorithms.entrySet()) {
            result.put(entry.getKey(), entry.getValue().checksum());
        }
        return result;
    }
}

