/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.extension3;

import eu.maveniverse.maven.mimir.shared.MimirUtils;
import eu.maveniverse.maven.mimir.shared.Session;
import eu.maveniverse.maven.shared.core.component.ComponentSupport;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmHelper;
import org.eclipse.aether.spi.resolution.ArtifactResolverPostProcessor;

@Singleton
@Named
public class MimirArtifactResolverPostProcessor
extends ComponentSupport
implements ArtifactResolverPostProcessor {
    private final ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector;

    @Inject
    public MimirArtifactResolverPostProcessor(ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector) {
        this.checksumAlgorithmFactorySelector = Objects.requireNonNull(checksumAlgorithmFactorySelector, "checksumAlgorithmFactorySelector");
    }

    public void postProcess(RepositorySystemSession session, List<ArtifactResult> artifactResults) {
        for (ArtifactResult artifactResult : artifactResults) {
            ArtifactRepository artifactRepository = artifactResult.getRepository();
            if (!(artifactRepository instanceof RemoteRepository)) continue;
            RemoteRepository remoteRepository = (RemoteRepository)artifactRepository;
            Optional sessionOptional = MimirUtils.mayGetSession((RepositorySystemSession)session);
            if (!sessionOptional.isPresent()) continue;
            Session ms = (Session)sessionOptional.orElseThrow();
            Artifact artifact = artifactResult.getArtifact();
            boolean resolved = artifactResult.isResolved();
            if (!resolved || !ms.repositorySupported(remoteRepository) || !ms.artifactSupported(artifact)) continue;
            try {
                if (ms.retrievedFromCache(remoteRepository, artifact) || ms.storedToCache(remoteRepository, artifact) || !ms.locate(remoteRepository, artifact).isEmpty()) continue;
                ms.store(remoteRepository, artifact, artifact.getFile().toPath(), Collections.emptyMap(), ChecksumAlgorithmHelper.calculate((File)artifact.getFile(), (List)this.checksumAlgorithmFactorySelector.selectList((Collection)ms.checksumAlgorithms())));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

