/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.extension3;

import eu.maveniverse.maven.mimir.node.daemon.DaemonConfig;
import eu.maveniverse.maven.mimir.shared.MimirUtils;
import eu.maveniverse.maven.mimir.shared.SessionConfig;
import eu.maveniverse.maven.mimir.shared.SessionFactory;
import eu.maveniverse.maven.shared.core.fs.FileUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class MimirLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final RepositorySystem repositorySystem;
    private final Provider<SessionFactory> sessionFactoryProvider;

    @Inject
    public MimirLifecycleParticipant(RepositorySystem repositorySystem, Provider<SessionFactory> sessionFactoryProvider) {
        this.repositorySystem = repositorySystem;
        this.sessionFactoryProvider = sessionFactoryProvider;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        try {
            RepositorySystemSession repoSession = session.getRepositorySession();
            SessionConfig sessionConfig = SessionConfig.defaults().userProperties(repoSession.getUserProperties()).systemProperties(repoSession.getSystemProperties()).repositorySystemSession(repoSession).build();
            if (sessionConfig.enabled()) {
                List remoteRepositories = RepositoryUtils.toRepos((List)session.getProjectBuildingRequest().getRemoteRepositories());
                this.mayCheckForUpdates(sessionConfig, repoSession, remoteRepositories);
                this.mayResolveDaemonArtifact(sessionConfig, repoSession, remoteRepositories);
                MimirUtils.lazyInit((RepositorySystemSession)session.getRepositorySession(), () -> {
                    try {
                        return ((SessionFactory)this.sessionFactoryProvider.get()).createSession(sessionConfig);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            } else {
                this.logger.info("Mimir {} is disabled", (Object)sessionConfig.mimirVersion());
            }
        }
        catch (Exception e) {
            if ("com.google.inject.ProvisionException".equals(e.getClass().getName())) {
                this.logger.error("Minir session creation failed", (Throwable)e);
            }
            throw new MavenExecutionException("Error enabling Mimir", (Throwable)e);
        }
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        try {
            MimirUtils.mayGetSession((RepositorySystemSession)session.getRepositorySession()).ifPresent(s -> {
                try {
                    s.close();
                }
                catch (IOException e) {
                    if (s.config().ignoreErrorAtSessionEnd()) {
                        this.logger.warn("Error closing Mimir session; ignoring", (Throwable)e);
                    }
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (Exception e) {
            throw new MavenExecutionException("Error closing Mimir session", (Throwable)e);
        }
    }

    private void mayResolveDaemonArtifact(SessionConfig sessionConfig, RepositorySystemSession session, List<RemoteRepository> remoteRepositories) {
        DaemonConfig daemonConfig = DaemonConfig.with((SessionConfig)sessionConfig);
        if (!daemonConfig.autostart()) {
            this.logger.debug("Not resolving Mimir daemon; autostart not enabled or version not detected");
            return;
        }
        if (!Files.exists(daemonConfig.daemonJar(), new LinkOption[0])) {
            try {
                this.logger.info("Resolving Mimir daemon version {}", (Object)sessionConfig.mimirVersion());
                ArtifactRequest artifactRequest = new ArtifactRequest((Artifact)new DefaultArtifact(daemonConfig.daemonGav()), remoteRepositories, "mimir");
                ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(session, artifactRequest);
                Files.createDirectories(daemonConfig.daemonJar().getParent(), new FileAttribute[0]);
                FileUtils.copy((Path)artifactResult.getArtifact().getFile().toPath(), (Path)daemonConfig.daemonJar());
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("Failed to resolve daemon:", (Throwable)e);
                }
                this.logger.warn("Failed to resolve daemon: {}", (Object)e.getMessage());
            }
        }
    }

    private void mayCheckForUpdates(SessionConfig sessionConfig, RepositorySystemSession session, List<RemoteRepository> remoteRepositories) {
        DaemonConfig daemonConfig = DaemonConfig.with((SessionConfig)sessionConfig);
        if (!daemonConfig.autoupdate()) {
            this.logger.debug("Not checking for Mimir updates; not enabled or version not detected");
            return;
        }
        try {
            String mimirVersion = sessionConfig.mimirVersion();
            this.logger.debug("Checking for Mimir updates...");
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest(new DefaultArtifact(daemonConfig.daemonGav()).setVersion("[" + mimirVersion + ",)"), remoteRepositories, "mimir");
            VersionRangeResult rangeResult = this.repositorySystem.resolveVersionRange(session, versionRangeRequest);
            List versions = rangeResult.getVersions();
            if (versions.size() > 1) {
                String latest = ((Version)versions.get(versions.size() - 1)).toString();
                if (!latest.endsWith("-SNAPSHOT") && !Objects.equals(mimirVersion, latest)) {
                    this.logger.info("Please upgrade to Mimir version {} (you are using version {})", (Object)latest, (Object)mimirVersion);
                }
            } else {
                this.logger.debug("Mimir {} is up to date", (Object)mimirVersion);
            }
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("Failed to check for updates; ignoring it:", (Throwable)e);
            }
            this.logger.warn("Failed to check for updates; ignoring it: {}", (Object)e.getMessage());
        }
    }
}

