/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.extension3;

import eu.maveniverse.maven.mimir.extension3.ChecksumCalculator;
import eu.maveniverse.maven.mimir.extension3.MimirTransferListener;
import eu.maveniverse.maven.mimir.shared.Entry;
import eu.maveniverse.maven.mimir.shared.Session;
import eu.maveniverse.maven.shared.core.component.ComponentSupport;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithm;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.FileUtils;
import org.eclipse.aether.util.listener.ChainedTransferListener;

public class MimirRepositoryConnector
extends ComponentSupport
implements RepositoryConnector {
    private final Session mimirSession;
    private final RemoteRepository remoteRepository;
    private final RepositoryConnector delegate;
    private final List<ChecksumAlgorithmFactory> resolverChecksumAlgorithmFactories;
    private final Map<String, ChecksumAlgorithmFactory> allChecksumAlgorithmFactoryMap;

    public MimirRepositoryConnector(Session mimirSession, RemoteRepository remoteRepository, RepositoryConnector delegate, List<ChecksumAlgorithmFactory> resolverChecksumAlgorithmFactories, Map<String, ChecksumAlgorithmFactory> allChecksumAlgorithmFactoryMap) {
        this.mimirSession = Objects.requireNonNull(mimirSession, "mimirSession");
        this.remoteRepository = Objects.requireNonNull(remoteRepository, "remoteRepository");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.resolverChecksumAlgorithmFactories = Objects.requireNonNull(resolverChecksumAlgorithmFactories, "resolverChecksumAlgorithmFactories");
        this.allChecksumAlgorithmFactoryMap = Objects.requireNonNull(allChecksumAlgorithmFactoryMap, "allChecksumAlgorithmFactoryMap");
    }

    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        ArrayList<ArtifactDownload> ads = new ArrayList<ArtifactDownload>();
        HashMap<Artifact, PotentiallyCached> keys = new HashMap<Artifact, PotentiallyCached>();
        if (artifactDownloads != null && !artifactDownloads.isEmpty()) {
            for (ArtifactDownload artifactDownload : artifactDownloads) {
                if (artifactDownload.isExistenceCheck() || !this.mimirSession.artifactSupported(artifactDownload.getArtifact())) {
                    ads.add(artifactDownload);
                    continue;
                }
                try {
                    Optional entry = this.mimirSession.locate(this.remoteRepository, artifactDownload.getArtifact());
                    if (entry.isPresent()) {
                        Entry ce = (Entry)entry.orElseThrow(() -> new IllegalStateException("Value not present"));
                        this.logger.debug("Fetched {} from Mimir cache", (Object)artifactDownload.getArtifact());
                        Path artifactFile = artifactDownload.getFile().toPath();
                        ce.transferTo(artifactFile);
                        String checksum = null;
                        for (ChecksumAlgorithmFactory checksumAlgorithmFactory : this.resolverChecksumAlgorithmFactories) {
                            checksum = (String)ce.checksums().get(checksumAlgorithmFactory.getName());
                            if (checksum == null) continue;
                            String chk = checksum;
                            FileUtils.writeFile((Path)artifactFile.getParent().resolve(String.valueOf(artifactFile.getFileName()) + "." + checksumAlgorithmFactory.getFileExtension()), p -> Files.write(p, chk.getBytes(StandardCharsets.UTF_8), new OpenOption[0]));
                            break;
                        }
                        if (checksum != null) continue;
                        this.logger.warn("No checksum written for {}; resolver={} vs entry={}", new Object[]{artifactDownload.getArtifact(), this.resolverChecksumAlgorithmFactories.stream().map(ChecksumAlgorithmFactory::getName).collect(Collectors.joining(",")), String.join((CharSequence)",", ce.checksums().keySet())});
                        continue;
                    }
                    HashMap<String, ChecksumAlgorithm> checksumAlgorithms = new HashMap<String, ChecksumAlgorithm>();
                    for (String algorithm : this.mimirSession.checksumAlgorithms()) {
                        ChecksumAlgorithmFactory factory = this.allChecksumAlgorithmFactoryMap.get(algorithm);
                        if (factory == null) {
                            throw new IllegalStateException("Required checksum algorithm unavailable: " + algorithm);
                        }
                        checksumAlgorithms.put(factory.getName(), factory.getAlgorithm());
                    }
                    ChecksumCalculator checksumCalculator = new ChecksumCalculator(checksumAlgorithms);
                    MimirTransferListener transferListener = new MimirTransferListener(checksumCalculator);
                    PotentiallyCached potentiallyCached = new PotentiallyCached(artifactDownload.getArtifact(), checksumCalculator, transferListener);
                    ArtifactDownload artifactDownload2 = artifactDownload.setListener(ChainedTransferListener.newInstance((TransferListener)artifactDownload.getListener(), (TransferListener)transferListener));
                    keys.put(artifactDownload2.getArtifact(), potentiallyCached);
                    ads.add(artifactDownload2);
                }
                catch (IOException e) {
                    artifactDownload.setException(new ArtifactTransferException(artifactDownload.getArtifact(), this.remoteRepository, (Throwable)e));
                }
            }
        }
        this.delegate.get(ads, metadataDownloads);
        if (!ads.isEmpty()) {
            for (ArtifactDownload artifactDownload : ads) {
                PotentiallyCached potentiallyCached = (PotentiallyCached)keys.get(artifactDownload.getArtifact());
                if (potentiallyCached == null || !potentiallyCached.transferListener.isValid() || artifactDownload.getException() != null) continue;
                try {
                    this.logger.debug("Storing {} to Mimir 'local' cache", (Object)artifactDownload.getArtifact());
                    this.mimirSession.store(this.remoteRepository, potentiallyCached.artifact, artifactDownload.getFile().toPath(), Collections.emptyMap(), potentiallyCached.checksumCalculator.getChecksums());
                }
                catch (IOException e) {
                    artifactDownload.setException(new ArtifactTransferException(artifactDownload.getArtifact(), this.remoteRepository, (Throwable)e));
                }
            }
        }
    }

    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        this.delegate.put(artifactUploads, metadataUploads);
    }

    public void close() {
        this.delegate.close();
    }

    private static class PotentiallyCached {
        private final Artifact artifact;
        private final ChecksumCalculator checksumCalculator;
        private final MimirTransferListener transferListener;

        public PotentiallyCached(Artifact artifact, ChecksumCalculator checksumCalculator, MimirTransferListener transferListener) {
            this.artifact = artifact;
            this.checksumCalculator = checksumCalculator;
            this.transferListener = transferListener;
        }
    }
}

