/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.extension3;

import eu.maveniverse.maven.mimir.extension3.MimirRepositoryConnector;
import eu.maveniverse.maven.mimir.shared.MimirUtils;
import eu.maveniverse.maven.mimir.shared.Session;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.util.ConfigUtils;

@Named(value="mimir")
public class MimirRepositoryConnectorFactory
implements RepositoryConnectorFactory {
    public static final String NAME = "mimir";
    private final Map<String, Provider<RepositoryConnectorFactory>> repositoryConnectorFactories;
    private final ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector;

    @Inject
    public MimirRepositoryConnectorFactory(Map<String, Provider<RepositoryConnectorFactory>> repositoryConnectorFactories, ChecksumAlgorithmFactorySelector checksumAlgorithmFactorySelector) {
        this.repositoryConnectorFactories = Objects.requireNonNull(repositoryConnectorFactories, "repositoryConnectorFactories");
        this.checksumAlgorithmFactorySelector = Objects.requireNonNull(checksumAlgorithmFactorySelector, "checksumAlgorithmFactorySelector");
    }

    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        Object message = "Mimir is disabled";
        Optional sessionOptional = MimirUtils.mayGetSession((RepositorySystemSession)session);
        if (sessionOptional.isPresent()) {
            Session mimirSession = (Session)sessionOptional.orElseThrow();
            message = "Unsupported repository: " + String.valueOf(repository);
            if (mimirSession.repositorySupported(repository)) {
                RepositoryConnectorFactory basicRepositoryConnectorFactory = Objects.requireNonNull((RepositoryConnectorFactory)this.repositoryConnectorFactories.get("basic").get(), "No basic repository connector factory found");
                RepositoryConnector repositoryConnector = basicRepositoryConnectorFactory.newInstance(session, repository);
                List checksumsAlgorithms = this.checksumAlgorithmFactorySelector.selectList((Collection)ConfigUtils.parseCommaSeparatedUniqueNames((String)ConfigUtils.getString((RepositorySystemSession)session, (String)"SHA-1,MD5", (String[])new String[]{"aether.checksums.algorithms." + repository.getId(), "aether.checksums.algorithms", "aether.layout.maven2.checksumAlgorithms" + repository.getId(), "aether.layout.maven2.checksumAlgorithms"})));
                return new MimirRepositoryConnector(mimirSession, repository, repositoryConnector, checksumsAlgorithms, this.checksumAlgorithmFactorySelector.getChecksumAlgorithmFactories().stream().collect(Collectors.toMap(ChecksumAlgorithmFactory::getName, f -> f)));
            }
        }
        throw new NoRepositoryConnectorException(repository, (String)message);
    }

    public float getPriority() {
        return 10.0f;
    }
}

