/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.extension3;

import eu.maveniverse.maven.mimir.extension3.ChecksumCalculator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;

public class MimirTransferListener
extends AbstractTransferListener {
    private final ChecksumCalculator checksumCalculator;
    private final AtomicBoolean valid;

    public MimirTransferListener(ChecksumCalculator checksumCalculator) {
        this.checksumCalculator = Objects.requireNonNull(checksumCalculator, "checksumCalculator");
        this.valid = new AtomicBoolean(true);
    }

    public void transferStarted(TransferEvent event) {
        this.valid.set(event.getTransferredBytes() == 0L);
    }

    public void transferProgressed(TransferEvent event) {
        if (this.valid.get()) {
            this.checksumCalculator.update(event.getDataBuffer());
        }
    }

    public void transferFailed(TransferEvent event) {
        this.valid.set(false);
    }

    public void transferCorrupted(TransferEvent event) {
        this.valid.set(false);
    }

    public void transferSucceeded(TransferEvent event) {
        this.valid.compareAndSet(true, true);
    }

    public boolean isValid() {
        return this.valid.get();
    }
}

