/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.extension3;

import eu.maveniverse.maven.mimir.shared.Entry;
import eu.maveniverse.maven.mimir.shared.MimirUtils;
import eu.maveniverse.maven.mimir.shared.Session;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.checksums.TrustedChecksumsSource;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;

@Singleton
@Named
public class MimirTrustedChecksumsSource
implements TrustedChecksumsSource {
    public Map<String, String> getTrustedArtifactChecksums(RepositorySystemSession session, Artifact artifact, ArtifactRepository artifactRepository, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        if (artifactRepository instanceof RemoteRepository) {
            Session ms;
            RemoteRepository remoteRepository = (RemoteRepository)artifactRepository;
            Optional sessionOptional = MimirUtils.mayGetSession((RepositorySystemSession)session);
            if (sessionOptional.isPresent() && (ms = (Session)sessionOptional.orElseThrow()).repositorySupported(remoteRepository) && ms.artifactSupported(artifact)) {
                try {
                    Optional entry = ms.locate(remoteRepository, artifact);
                    if (entry.isPresent()) {
                        Entry cacheEntry = (Entry)entry.orElseThrow();
                        HashMap<String, String> result = new HashMap<String, String>();
                        for (ChecksumAlgorithmFactory checksumAlgorithmFactory : checksumAlgorithmFactories) {
                            String checksum = (String)cacheEntry.checksums().get(checksumAlgorithmFactory.getName());
                            if (checksum == null) continue;
                            result.put(checksumAlgorithmFactory.getName(), checksum);
                        }
                        return result;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return Collections.emptyMap();
    }

    public TrustedChecksumsSource.Writer getTrustedArtifactChecksumsWriter(RepositorySystemSession session) {
        return null;
    }
}

