/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.node.daemon;

import eu.maveniverse.maven.mimir.shared.SessionConfig;
import eu.maveniverse.maven.shared.core.fs.FileUtils;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;

public class DaemonConfig {
    public static final String NAME = "daemon";
    private final SessionConfig sessionConfig;
    private final Path daemonBasedir;
    private final Path daemonLockDir;
    private final Path socketPath;
    private final Path daemonJavaHome;
    private final boolean autoupdate;
    private final boolean autostart;
    private final Duration autostartDuration;
    private final boolean autostop;
    private final Path daemonJar;
    private final Path daemonLog;
    private final String daemonGav;
    private final boolean passOnBasedir;
    private final boolean debug;

    public static DaemonConfig with(SessionConfig sessionConfig) {
        Objects.requireNonNull(sessionConfig, "config");
        boolean mimirVersionPresent = !"unknown".equals(sessionConfig.mimirVersion());
        Path daemonBasedir = sessionConfig.basedir();
        if (sessionConfig.effectiveProperties().containsKey("mimir.daemon.basedir")) {
            daemonBasedir = FileUtils.canonicalPath((Path)sessionConfig.basedir().resolve((String)sessionConfig.effectiveProperties().get("mimir.daemon.basedir")));
        }
        Path daemonLockDir = daemonBasedir.resolve(NAME);
        Path socketPath = daemonBasedir.resolve("mimir-socket");
        Path daemonJavaHome = FileUtils.canonicalPath((Path)daemonBasedir.resolve(sessionConfig.effectiveProperties().getOrDefault("mimir.daemon.java.home", (String)sessionConfig.effectiveProperties().get("java.home"))));
        boolean autoupdate = mimirVersionPresent;
        boolean autostart = mimirVersionPresent;
        Duration autostartDuration = Duration.ofMinutes(1L);
        boolean autostop = false;
        Path daemonJar = daemonBasedir.resolve("daemon-" + sessionConfig.mimirVersion() + ".jar");
        Path daemonLog = daemonBasedir.resolve("daemon-" + sessionConfig.mimirVersion() + ".log");
        Object daemonGav = "eu.maveniverse.maven.mimir:daemon:jar:daemon:" + sessionConfig.mimirVersion();
        boolean passOnBasedir = false;
        boolean debug = false;
        if (sessionConfig.effectiveProperties().containsKey("mimir.daemon.socketPath")) {
            socketPath = FileUtils.canonicalPath((Path)daemonBasedir.resolve((String)sessionConfig.effectiveProperties().get("mimir.daemon.socketPath")));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.daemon.autoupdate")) {
            autoupdate = Boolean.parseBoolean((String)sessionConfig.effectiveProperties().get("mimir.daemon.autoupdate"));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.daemon.autostart")) {
            autostart = Boolean.parseBoolean((String)sessionConfig.effectiveProperties().get("mimir.daemon.autostart"));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.daemon.autostartDuration")) {
            autostartDuration = Duration.parse((CharSequence)sessionConfig.effectiveProperties().get("mimir.daemon.autostartDuration"));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.daemon.autostop")) {
            autostop = Boolean.parseBoolean((String)sessionConfig.effectiveProperties().get("mimir.daemon.autostop"));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.daemon.daemonJar")) {
            daemonJar = FileUtils.canonicalPath((Path)daemonBasedir.resolve((String)sessionConfig.effectiveProperties().get("mimir.daemon.daemonJar")));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.daemon.daemonLog")) {
            daemonLog = FileUtils.canonicalPath((Path)daemonBasedir.resolve((String)sessionConfig.effectiveProperties().get("mimir.daemon.daemonLog")));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.daemon.daemonGav")) {
            daemonGav = (String)sessionConfig.effectiveProperties().get("mimir.daemon.daemonGav");
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.daemon.passOnBasedir")) {
            passOnBasedir = Boolean.parseBoolean((String)sessionConfig.effectiveProperties().get("mimir.daemon.passOnBasedir"));
        }
        if (sessionConfig.effectiveProperties().containsKey("mimir.daemon.debug")) {
            debug = Boolean.parseBoolean((String)sessionConfig.effectiveProperties().get("mimir.daemon.debug"));
        }
        return new DaemonConfig(sessionConfig, daemonBasedir, daemonLockDir, socketPath, daemonJavaHome, autoupdate, autostart, autostartDuration, autostop, daemonJar, daemonLog, (String)daemonGav, passOnBasedir, debug);
    }

    private DaemonConfig(SessionConfig sessionConfig, Path daemonBasedir, Path daemonLockDir, Path socketPath, Path daemonJavaHome, boolean autoupdate, boolean autostart, Duration autostartDuration, boolean autostop, Path daemonJar, Path daemonLog, String daemonGav, boolean passOnBasedir, boolean debug) {
        this.sessionConfig = Objects.requireNonNull(sessionConfig);
        this.daemonBasedir = Objects.requireNonNull(daemonBasedir);
        this.daemonLockDir = Objects.requireNonNull(daemonLockDir);
        this.socketPath = Objects.requireNonNull(socketPath);
        this.daemonJavaHome = Objects.requireNonNull(daemonJavaHome);
        this.autoupdate = autoupdate;
        this.autostart = autostart;
        this.autostartDuration = Objects.requireNonNull(autostartDuration);
        this.autostop = autostop;
        this.daemonJar = Objects.requireNonNull(daemonJar);
        this.daemonLog = Objects.requireNonNull(daemonLog);
        this.daemonGav = Objects.requireNonNull(daemonGav);
        this.passOnBasedir = passOnBasedir;
        this.debug = debug;
    }

    public SessionConfig config() {
        return this.sessionConfig;
    }

    public Path daemonBasedir() {
        return this.daemonBasedir;
    }

    public Path daemonLockDir() {
        return this.daemonLockDir;
    }

    public Path socketPath() {
        return this.socketPath;
    }

    public Path daemonJavaHome() {
        return this.daemonJavaHome;
    }

    public boolean autoupdate() {
        return this.autoupdate;
    }

    public boolean autostart() {
        return this.autostart;
    }

    public Duration autostartDuration() {
        return this.autostartDuration;
    }

    public boolean autostop() {
        return this.autostop;
    }

    public Path daemonJar() {
        return this.daemonJar;
    }

    public Path daemonLog() {
        return this.daemonLog;
    }

    public String daemonGav() {
        return this.daemonGav;
    }

    public boolean passOnBasedir() {
        return this.passOnBasedir;
    }

    public boolean debug() {
        return this.debug;
    }
}

