/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.node.daemon;

import eu.maveniverse.maven.mimir.daemon.protocol.Handle;
import eu.maveniverse.maven.mimir.daemon.protocol.Request;
import eu.maveniverse.maven.mimir.daemon.protocol.Response;
import eu.maveniverse.maven.mimir.node.daemon.DaemonConfig;
import eu.maveniverse.maven.mimir.shared.impl.Utils;
import eu.maveniverse.maven.mimir.shared.impl.node.EntrySupport;
import eu.maveniverse.maven.mimir.shared.impl.node.NodeSupport;
import eu.maveniverse.maven.mimir.shared.node.LocalEntry;
import eu.maveniverse.maven.mimir.shared.node.LocalNode;
import eu.maveniverse.maven.shared.core.fs.FileUtils;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;

public class DaemonNode
extends NodeSupport<DaemonEntry>
implements LocalNode<DaemonEntry> {
    private final DaemonConfig daemonConfig;
    private final Handle.ClientHandle clientHandle;
    private final Map<String, ChecksumAlgorithmFactory> checksumFactories;
    private final boolean autostop;
    private final Map<String, String> session;
    private final Map<String, String> daemonData;

    public DaemonNode(Map<String, String> clientData, DaemonConfig daemonConfig, Map<String, ChecksumAlgorithmFactory> checksumFactories, boolean autostop) throws IOException {
        super("daemon");
        this.daemonConfig = Objects.requireNonNull(daemonConfig, "daemonConfig");
        this.clientHandle = Handle.clientDomainSocket((Path)daemonConfig.socketPath());
        this.checksumFactories = Collections.unmodifiableMap(Objects.requireNonNull(checksumFactories, "checksumFactories"));
        this.autostop = autostop;
        try (Handle handle = this.clientHandle.getHandle();){
            handle.writeRequest(Request.hello(clientData));
            Response helloResponse = handle.readResponse();
            this.session = helloResponse.session();
            this.daemonData = helloResponse.data();
            this.logger.debug("Hello OK {}", (Object)helloResponse.data());
        }
    }

    public List<String> checksumAlgorithms() throws IOException {
        try (Handle handle = this.clientHandle.getHandle();){
            handle.writeRequest(Request.lsChecksums(this.session));
            ArrayList<String> arrayList = new ArrayList<String>(handle.readResponse().data().keySet());
            return arrayList;
        }
    }

    public Map<String, ChecksumAlgorithmFactory> checksumFactories() {
        return this.checksumFactories;
    }

    public Optional<DaemonEntry> locate(URI key) throws IOException {
        String keyString = key.toASCIIString();
        this.logger.debug("LOCATE '{}'", (Object)keyString);
        try (Handle handle = this.clientHandle.getHandle();){
            handle.writeRequest(Request.locate(this.session, (String)keyString));
            Response locateResponse = handle.readResponse();
            if (!locateResponse.data().isEmpty()) {
                Optional<DaemonEntry> optional = Optional.of(new DaemonEntry(Utils.splitMetadata((Map)locateResponse.data()), Utils.splitChecksums((Map)locateResponse.data()), keyString));
                return optional;
            }
            Optional<DaemonEntry> optional = Optional.empty();
            return optional;
        }
    }

    public DaemonEntry store(URI key, Path file, Map<String, String> metadata, Map<String, String> checksums) throws IOException {
        String keyString = key.toASCIIString();
        String filePath = FileUtils.canonicalPath((Path)file).toString();
        this.logger.debug("STORE PATH '{}' -> '{}'", (Object)keyString, (Object)filePath);
        try (Handle handle = this.clientHandle.getHandle();){
            handle.writeRequest(Request.storePath(this.session, (String)keyString, (String)filePath, (Map)Utils.mergeEntry(metadata, checksums)));
            Response storePathResponse = handle.readResponse();
            if (!storePathResponse.data().isEmpty()) {
                DaemonEntry daemonEntry = new DaemonEntry(Utils.splitMetadata((Map)storePathResponse.data()), Utils.splitChecksums((Map)storePathResponse.data()), keyString);
                return daemonEntry;
            }
            throw new IOException("Failed to store " + filePath + "; check daemon logs");
        }
    }

    protected void doClose() throws IOException {
        try (Handle.ClientHandle clientHandle = this.clientHandle;
             Handle handle = this.clientHandle.getHandle();){
            if (this.autostop) {
                this.logger.info("Daemon shutdown initiated");
            }
            handle.writeRequest(Request.bye(this.session, (boolean)this.autostop));
            Response byeResponse = handle.readResponse();
            this.logger.debug("Bye OK {}", (Object)byeResponse.data());
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " (basedir=" + String.valueOf(this.daemonConfig.daemonBasedir()) + "; daemonPID=" + this.daemonData.getOrDefault("daemon.pid", "n/a") + "; daemonVersion=" + this.daemonData.getOrDefault("daemon.version", "n/a") + ")";
    }

    public class DaemonEntry
    extends EntrySupport
    implements LocalEntry {
        private final String keyString;

        private DaemonEntry(Map<String, String> metadata, Map<String, String> checksums, String keyString) {
            super(metadata, checksums);
            this.keyString = keyString;
        }

        public void transferTo(Path file) throws IOException {
            this.logger.debug("TRANSFER '{}'->'{}'", (Object)this.keyString, (Object)file);
            try (Handle handle = DaemonNode.this.clientHandle.getHandle();){
                handle.writeRequest(Request.transfer(DaemonNode.this.session, (String)this.keyString, (String)FileUtils.canonicalPath((Path)file).toString()));
                handle.readResponse();
            }
        }
    }
}

