/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.node.daemon;

import eu.maveniverse.maven.mimir.node.daemon.DaemonConfig;
import eu.maveniverse.maven.mimir.node.daemon.DaemonNode;
import eu.maveniverse.maven.mimir.shared.SessionConfig;
import eu.maveniverse.maven.mimir.shared.node.LocalNodeFactory;
import eu.maveniverse.maven.shared.core.component.ComponentSupport;
import eu.maveniverse.maven.shared.core.fs.DirectoryLocker;
import eu.maveniverse.maven.shared.core.fs.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;

@Singleton
@Named(value="daemon")
public class DaemonNodeFactory
extends ComponentSupport
implements LocalNodeFactory {
    private final Map<String, ChecksumAlgorithmFactory> checksumAlgorithmFactories;

    @Inject
    public DaemonNodeFactory(Map<String, ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        this.checksumAlgorithmFactories = Objects.requireNonNull(checksumAlgorithmFactories, "checksumAlgorithmFactories");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DaemonNode createNode(SessionConfig sessionConfig) throws IOException {
        DaemonConfig cfg = DaemonConfig.with(sessionConfig);
        if (this.tryLock(cfg)) {
            Files.deleteIfExists(cfg.socketPath());
            if (!cfg.autostart()) throw new IOException("Mimir daemon does not run and autostart is disabled; start daemon manually");
            this.logger.debug("Mimir daemon is not running, starting it");
            Process daemon = this.startDaemon(cfg);
            this.logger.info("Mimir daemon started (pid={})", (Object)daemon.pid());
        } else if (!Files.exists(cfg.socketPath(), new LinkOption[0])) {
            this.waitForSocket(cfg);
        }
        if (!Files.exists(cfg.socketPath(), new LinkOption[0])) {
            throw new IOException("Mimir daemon socket not found");
        }
        HashMap<String, String> clientData = new HashMap<String, String>();
        clientData.put("node.pid", Long.toString(ProcessHandle.current().pid()));
        clientData.put("node.version", sessionConfig.mimirVersion());
        if (cfg.config().repositorySystemSession().isPresent()) {
            RepositorySystemSession session = (RepositorySystemSession)cfg.config().repositorySystemSession().orElseThrow();
            clientData.put("lrm.path", FileUtils.canonicalPath((Path)session.getLocalRepository().getBasedir().toPath()).toString());
        }
        try {
            return new DaemonNode(clientData, cfg, this.checksumAlgorithmFactories, cfg.autostop());
        }
        catch (IOException e) {
            this.mayDumpDaemonLog(cfg.daemonLog());
            throw e;
        }
    }

    private Process startDaemon(DaemonConfig cfg) throws IOException {
        Path basedir = cfg.daemonBasedir();
        if (Files.isRegularFile(cfg.daemonJar(), new LinkOption[0])) {
            String java = cfg.daemonJavaHome().resolve("bin").resolve(cfg.config().effectiveProperties().getOrDefault("os.name", "unknown").startsWith("Windows") ? "java.exe" : "java").toString();
            ArrayList<String> command = new ArrayList<String>();
            command.add(java);
            if (cfg.debug()) {
                command.add("-Dorg.slf4j.simpleLogger.defaultLogLevel=debug");
            }
            if (cfg.passOnBasedir()) {
                command.add("-Dmimir.basedir=" + String.valueOf(basedir));
            }
            command.add("-jar");
            command.add(cfg.daemonJar().toString());
            ProcessBuilder pb = new ProcessBuilder(new String[0]).directory(basedir.toFile()).redirectOutput(cfg.daemonLog().toFile()).command(command);
            this.unlock(cfg);
            Process p = pb.start();
            try {
                this.waitForSocket(cfg);
            }
            catch (IOException e) {
                p.destroy();
                throw e;
            }
            if (p.isAlive()) {
                return p;
            }
            this.mayDumpDaemonLog(cfg.daemonLog());
            throw new IOException("Failed to start daemon; check daemon logs in " + String.valueOf(cfg.daemonLog()));
        }
        throw new IOException("Mimir daemon JAR not found");
    }

    private void mayDumpDaemonLog(Path daemonLog) throws IOException {
        if (Files.isRegularFile(daemonLog, new LinkOption[0])) {
            this.logger.error("Daemon log dump:\n{}", (Object)Files.readString(daemonLog));
        }
    }

    private boolean tryLock(DaemonConfig cfg) {
        try {
            Files.createDirectories(cfg.daemonLockDir(), new FileAttribute[0]);
            DirectoryLocker.INSTANCE.lockDirectory(cfg.daemonLockDir(), true);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void unlock(DaemonConfig cfg) throws IOException {
        DirectoryLocker.INSTANCE.unlockDirectory(cfg.daemonLockDir());
    }

    private void waitForSocket(DaemonConfig cfg) throws IOException {
        Instant startingUntil = Instant.now().plus(cfg.autostartDuration());
        this.logger.debug("Waiting for socket to become available until {}", (Object)startingUntil);
        try {
            while (!Files.exists(cfg.socketPath(), new LinkOption[0])) {
                if (Instant.now().isAfter(startingUntil)) {
                    this.mayDumpDaemonLog(cfg.daemonLog());
                    throw new IOException("Failed to start daemon in time " + String.valueOf(cfg.autostartDuration()) + "; check daemon logs in " + String.valueOf(cfg.daemonLog()));
                }
                this.logger.debug("... waiting");
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted", e);
        }
        if (!Files.exists(cfg.socketPath(), new LinkOption[0])) {
            this.mayDumpDaemonLog(cfg.daemonLog());
            throw new IOException("Failed to start daemon; check daemon logs in " + String.valueOf(cfg.daemonLog()));
        }
    }
}

