/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mimir.testing;

import eu.maveniverse.maven.mimir.daemon.protocol.Handle;
import eu.maveniverse.maven.mimir.daemon.protocol.Request;
import eu.maveniverse.maven.mimir.daemon.protocol.Response;
import eu.maveniverse.maven.mimir.shared.SessionConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;

public final class MimirInfuser {
    public static final String MIMIR_EXTENSION_GROUP_ID = "eu.maveniverse.maven.mimir";
    public static final String MIMIR_EXTENSION_ARTIFACT_ID = "extension3";
    public static final AtomicReference<String> MIMIR_VERSION = new AtomicReference<String>("UNKNOWN");

    public static void preseedItselfIntoInnerUserHome(Path innerUserHome) throws IOException {
        Objects.requireNonNull(innerUserHome);
        MimirInfuser.preseedItselfIntoInnerLocalRepository(innerUserHome.resolve(".m2").resolve("repository"));
    }

    public static void preseedItselfIntoInnerLocalRepository(Path innerLocalRepository) throws IOException {
        Objects.requireNonNull(innerLocalRepository);
        SessionConfig sessionConfig = SessionConfig.defaults().build();
        try (Handle.ClientHandle client = Handle.clientDomainSocket((Path)sessionConfig.basedir().resolve("mimir-socket"));){
            Map session;
            Response response;
            try (Handle handle = client.getHandle();){
                HashMap<String, String> clientData = new HashMap<String, String>();
                clientData.put("node.pid", Long.toString(ProcessHandle.current().pid()));
                clientData.put("node.version", MIMIR_VERSION.get());
                handle.writeRequest(Request.hello(clientData));
                response = handle.readResponse();
                if ("KO ".equals(response.status())) {
                    throw new IOException("KO: " + String.valueOf(response.data()));
                }
                session = response.session();
            }
            handle = client.getHandle();
            try {
                handle.writeRequest(Request.preseedItself((Map)session, (String)innerLocalRepository.toAbsolutePath().toString(), Map.of()));
                response = handle.readResponse();
                if ("KO ".equals(response.status())) {
                    throw new IOException("KO: " + String.valueOf(response.data()));
                }
            }
            finally {
                if (handle != null) {
                    handle.close();
                }
            }
            handle = client.getHandle();
            try {
                handle.writeRequest(Request.bye((Map)session, (boolean)false));
                response = handle.readResponse();
                if ("KO ".equals(response.status())) {
                    throw new IOException("KO: " + String.valueOf(response.data()));
                }
            }
            finally {
                if (handle != null) {
                    handle.close();
                }
            }
        }
    }

    public static void preseedArtifactsIntoInnerUserHome(Path innerUserHome, Collection<String> artifacts) throws IOException {
        Objects.requireNonNull(innerUserHome);
        MimirInfuser.preseedArtifactIntoInnerLocalRepository(innerUserHome.resolve(".m2").resolve("repository"), artifacts);
    }

    public static void preseedArtifactIntoInnerLocalRepository(Path innerLocalRepository, Collection<String> artifacts) throws IOException {
        Objects.requireNonNull(innerLocalRepository);
        SessionConfig sessionConfig = SessionConfig.defaults().build();
        try (Handle.ClientHandle client = Handle.clientDomainSocket((Path)sessionConfig.basedir().resolve("mimir-socket"));){
            Map session;
            Response response;
            try (Handle handle = client.getHandle();){
                HashMap<String, String> clientData = new HashMap<String, String>();
                clientData.put("node.pid", Long.toString(ProcessHandle.current().pid()));
                clientData.put("node.version", MIMIR_VERSION.get());
                handle.writeRequest(Request.hello(clientData));
                response = handle.readResponse();
                if ("KO ".equals(response.status())) {
                    throw new IOException("KO: " + String.valueOf(response.data()));
                }
                session = response.session();
            }
            handle = client.getHandle();
            try {
                handle.writeRequest(Request.preseed((Map)session, (String)String.join((CharSequence)";", artifacts), (String)innerLocalRepository.toAbsolutePath().toString(), Map.of()));
                response = handle.readResponse();
                if ("KO ".equals(response.status())) {
                    throw new IOException("KO: " + String.valueOf(response.data()));
                }
            }
            finally {
                if (handle != null) {
                    handle.close();
                }
            }
            handle = client.getHandle();
            try {
                handle.writeRequest(Request.bye((Map)session, (boolean)false));
                response = handle.readResponse();
                if ("KO ".equals(response.status())) {
                    throw new IOException("KO: " + String.valueOf(response.data()));
                }
            }
            finally {
                if (handle != null) {
                    handle.close();
                }
            }
        }
    }

    public static String extensionsXml(String version) {
        Objects.requireNonNull(version);
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<extensions>" + System.lineSeparator() + "    <extension>" + System.lineSeparator() + "        <groupId>eu.maveniverse.maven.mimir</groupId>" + System.lineSeparator() + "        <artifactId>extension3</artifactId>" + System.lineSeparator() + "        <version>" + version + "</version>" + System.lineSeparator() + "    </extension>" + System.lineSeparator() + "</extensions>" + System.lineSeparator();
    }

    public static boolean isMimirPresentInExtensionsXml(Path extensionXmlPath) throws IOException {
        if (Files.isRegularFile(extensionXmlPath, new LinkOption[0])) {
            String extensionsXml = Files.readString(extensionXmlPath);
            return extensionsXml.contains("<groupId>eu.maveniverse.maven.mimir</groupId>") && extensionsXml.contains("<artifactId>extension3</artifactId>");
        }
        return false;
    }

    public static boolean isMimirPresentUW() throws IOException {
        return MimirInfuser.isMimirPresentInExtensionsXml(Path.of(System.getProperty("user.home"), new String[0]).resolve(".m2").resolve("extensions.xml"));
    }

    public static boolean isMimirPresentPW(Path outerSessionRoot) throws IOException {
        return MimirInfuser.isMimirPresentInExtensionsXml(outerSessionRoot.resolve(".mvn").resolve("extensions.xml"));
    }

    public static void doInfuseUW(Path innerUserHome) throws IOException {
        MimirInfuser.doInfuseUW(MIMIR_VERSION.get(), innerUserHome);
    }

    public static void doInfuseUW(String mimirVersion, Path innerUserHome) throws IOException {
        Path outerUserHome = Path.of(System.getProperty("user.home"), new String[0]);
        Path innerUWExtensions = innerUserHome.resolve(".m2").resolve("extensions.xml");
        Files.createDirectories(innerUWExtensions.getParent(), new FileAttribute[0]);
        Files.writeString(innerUWExtensions, (CharSequence)MimirInfuser.extensionsXml(mimirVersion), new OpenOption[0]);
        MimirInfuser.infuseMimirSession(outerUserHome, innerUserHome);
    }

    public static void doInfusePW(Path innerSessionRoot, Path innerUserHome) throws IOException {
        MimirInfuser.doInfusePW(MIMIR_VERSION.get(), innerSessionRoot, innerUserHome);
    }

    public static void doInfusePW(String mimirVersion, Path innerSessionRoot, Path innerUserHome) throws IOException {
        Path outerUserHome = Path.of(System.getProperty("user.home"), new String[0]);
        Path innerPWExtensions = innerSessionRoot.resolve(".mvn").resolve("extensions.xml");
        Files.createDirectories(innerPWExtensions.getParent(), new FileAttribute[0]);
        Files.writeString(innerPWExtensions, (CharSequence)MimirInfuser.extensionsXml(mimirVersion), new OpenOption[0]);
        MimirInfuser.infuseMimirSession(outerUserHome, innerUserHome);
    }

    public static boolean infuseUW(Path innerUserHome) throws IOException {
        Objects.requireNonNull(innerUserHome);
        Path outerUserHome = Path.of(System.getProperty("user.home"), new String[0]);
        Path outerUWExtensions = outerUserHome.resolve(".m2").resolve("extensions.xml");
        Path innerUWExtensions = innerUserHome.resolve(".m2").resolve("extensions.xml");
        return MimirInfuser.infuseMimir(outerUWExtensions, outerUserHome, innerUWExtensions, innerUserHome);
    }

    public static boolean infusePW(Path outerSessionRoot, Path innerSessionRoot, Path innerUserHome) throws IOException {
        Objects.requireNonNull(outerSessionRoot);
        Objects.requireNonNull(innerSessionRoot);
        Objects.requireNonNull(innerUserHome);
        Path outerUserHome = Path.of(System.getProperty("user.home"), new String[0]);
        Path outerPWExtensions = outerSessionRoot.resolve(".mvn").resolve("extensions.xml");
        Path innerPWExtensions = innerSessionRoot.resolve(".mvn").resolve("extensions.xml");
        return MimirInfuser.infuseMimir(outerPWExtensions, outerUserHome, innerPWExtensions, innerUserHome);
    }

    public static boolean infuseMimir(Path outerExtensions, Path outerUserHome, Path innerExtensions, Path innerUserHome) throws IOException {
        if (MimirInfuser.isMimirPresentInExtensionsXml(outerExtensions) && !Files.isRegularFile(innerExtensions, new LinkOption[0])) {
            Files.createDirectories(innerExtensions.getParent(), new FileAttribute[0]);
            Files.copy(outerExtensions, innerExtensions, StandardCopyOption.REPLACE_EXISTING);
            MimirInfuser.infuseMimirSession(outerUserHome, innerUserHome);
            return true;
        }
        return false;
    }

    public static void infuseMimirSession(Path outerUserHome, Path innerUserHome) throws IOException {
        Properties properties = MimirInfuser.innerMimirSessionProperties(outerUserHome.resolve(".mimir"));
        Path innerMimirProperties = innerUserHome.resolve(".mimir").resolve("session.properties");
        Files.createDirectories(innerMimirProperties.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(innerMimirProperties, new OpenOption[0]);){
            properties.store(os, "Written by MimirInfuser");
        }
    }

    public static Properties innerMimirSessionProperties(Path outerMimirBasedir) {
        Objects.requireNonNull(outerMimirBasedir);
        Properties properties = new Properties();
        properties.setProperty("mimir.daemon.basedir", outerMimirBasedir.toString());
        properties.setProperty("mimir.daemon.autoupdate", "false");
        properties.setProperty("mimir.daemon.autostart", "false");
        return properties;
    }

    static {
        Properties props = new Properties();
        try (InputStream is = MimirInfuser.class.getClassLoader().getResourceAsStream("META-INF/maven/eu.maveniverse.maven.mimir/testing/pom.properties");){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (props.containsKey("version")) {
            MIMIR_VERSION.set(props.getProperty("version"));
        }
    }
}

