/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.nisse.extension3.internal;

import eu.maveniverse.maven.nisse.core.internal.SimpleNisseConfiguration;
import eu.maveniverse.maven.nisse.extension3.internal.NissePropertyInliner;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
class NisseLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final NissePropertyInliner inliner;

    @Inject
    public NisseLifecycleParticipant(NissePropertyInliner inliner) {
        this.inliner = Objects.requireNonNull(inliner, "inliner");
    }

    public void afterSessionStart(MavenSession session) throws MavenExecutionException {
        try {
            SimpleNisseConfiguration configuration = SimpleNisseConfiguration.builder().withSystemProperties(session.getSystemProperties()).withUserProperties(session.getUserProperties()).withCurrentWorkingDirectory(Paths.get(session.getRequest().getBaseDirectory(), new String[0])).withSessionRootDirectory(session.getRequest().getMultiModuleProjectDirectory().toPath()).build();
            for (String inlinedKey : configuration.getInlinedPropertyKeys()) {
                if (!this.inliner.inlinedKeys(session).add(inlinedKey)) continue;
                this.logger.info("Nisse property {} configured for inlining", (Object)inlinedKey);
            }
        }
        catch (IOException e) {
            throw new MavenExecutionException("Error while creating Nisse configuration", (Throwable)e);
        }
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        try {
            this.inliner.mayInlinePom(session, session.getProjects());
        }
        catch (IOException e) {
            throw new MavenExecutionException("Nisse failed to inline", (Throwable)e);
        }
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        try {
            this.inliner.cleanup(session, session.getProjects());
        }
        catch (IOException e) {
            throw new MavenExecutionException("Nisse failed to inline", (Throwable)e);
        }
    }
}

