/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.nisse.extension4.internal;

import eu.maveniverse.maven.nisse.core.NisseConfiguration;
import eu.maveniverse.maven.nisse.core.NisseManager;
import eu.maveniverse.maven.nisse.core.Version;
import eu.maveniverse.maven.nisse.core.internal.SimpleNisseConfiguration;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.ProtoSession;
import org.apache.maven.api.spi.PropertyContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
final class NissePropertyContributor
implements PropertyContributor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final NisseManager nisseManager;

    @Inject
    public NissePropertyContributor(NisseManager nisseManager) {
        this.nisseManager = Objects.requireNonNull(nisseManager, "nisseManager");
    }

    public Map<String, String> contribute(ProtoSession protoSession) {
        try {
            this.logger.info("Maveniverse Nisse {} loaded", (Object)Version.version());
            SimpleNisseConfiguration configuration = SimpleNisseConfiguration.builder().withSystemProperties(protoSession.getSystemProperties()).withUserProperties(protoSession.getUserProperties()).withCurrentWorkingDirectory(protoSession.getTopDirectory()).withSessionRootDirectory(protoSession.getRootDirectory()).build();
            HashMap<String, String> result = new HashMap<String, String>(protoSession.getUserProperties());
            Map nisseProperties = this.nisseManager.createProperties((NisseConfiguration)configuration);
            this.logger.info("Nisse injecting {} properties into User Properties", (Object)nisseProperties.size());
            if (Boolean.parseBoolean(protoSession.getUserProperties().getOrDefault("nisse.dump", "false"))) {
                nisseProperties.forEach((k, v) -> this.logger.info("{}={}", k, v));
            }
            result.putAll(nisseProperties);
            return result;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while creating Nisse configuration", e);
        }
    }
}

