/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.extension3;

import eu.maveniverse.maven.njord.shared.NjordUtils;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.SessionConfig;
import eu.maveniverse.maven.njord.shared.SessionFactory;
import eu.maveniverse.maven.njord.shared.impl.J8Utils;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class NjordSessionLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Provider<SessionFactory> sessionFactoryProvider;

    @Inject
    public NjordSessionLifecycleParticipant(Provider<SessionFactory> sessionFactoryProvider) {
        this.sessionFactoryProvider = Objects.requireNonNull(sessionFactoryProvider);
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Objects.requireNonNull(session);
        try {
            SessionConfig sc = SessionConfig.defaults((RepositorySystemSession)session.getRepositorySession(), (List)RepositoryUtils.toRepos((List)session.getRequest().getRemoteRepositories())).currentProject(SessionConfig.fromMavenProject((MavenProject)session.getTopLevelProject())).build();
            Session ns = NjordUtils.lazyInit((SessionConfig)sc, arg_0 -> ((SessionFactory)((SessionFactory)this.sessionFactoryProvider.get())).create(arg_0));
            if (ns.config().enabled()) {
                this.logger.info("Njord {} session created", (Object)ns.config().version().orElse("UNKNOWN"));
            }
        }
        catch (Exception e) {
            if ("com.google.inject.ProvisionException".equals(e.getClass().getName())) {
                this.logger.error("Njord session creation failed", (Throwable)e);
            }
            throw new MavenExecutionException("Error enabling Njord", (Throwable)e);
        }
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        Objects.requireNonNull(session);
        try {
            Optional ns = NjordUtils.mayGetNjordSession((RepositorySystemSession)session.getRepositorySession());
            if (ns.isPresent()) {
                Session njordSession = (Session)ns.orElseThrow(J8Utils.OET);
                if (njordSession.config().enabled()) {
                    if (session.getResult().hasExceptions()) {
                        int dropped = njordSession.dropSessionArtifactStores();
                        if (dropped != 0) {
                            this.logger.warn("Session failed; dropped {} stores created in this session", (Object)dropped);
                        }
                    } else if (njordSession.config().autoPublish()) {
                        int published = njordSession.publishSessionArtifactStores();
                        if (published != 0) {
                            this.logger.info("Auto publish: Published {} stores created in this session", (Object)published);
                            int dropped = njordSession.dropSessionArtifactStores();
                            if (dropped != 0) {
                                this.logger.info("Auto publish: Dropped {} auto published stores", (Object)dropped);
                            }
                        } else {
                            this.logger.info("Auto publish: No stores created in this session");
                        }
                    }
                    this.logger.info("Njord session closed");
                }
                njordSession.close();
            }
        }
        catch (IOException e) {
            throw new MavenExecutionException("Error closing Njord", (Throwable)e);
        }
    }
}

