/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.extension3;

import eu.maveniverse.maven.njord.extension3.NjordRepositoryConnector;
import eu.maveniverse.maven.njord.shared.NjordUtils;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.impl.J8Utils;
import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="njord")
public class NjordRepositoryConnectorFactory
implements RepositoryConnectorFactory {
    public static final String NAME = "njord";
    private final Logger logger = LoggerFactory.getLogger(NjordRepositoryConnectorFactory.class);
    private final Map<String, Provider<RepositoryConnectorFactory>> repositoryConnectorFactories;

    @Inject
    public NjordRepositoryConnectorFactory(Map<String, Provider<RepositoryConnectorFactory>> repositoryConnectorFactories) {
        this.repositoryConnectorFactories = Objects.requireNonNull(repositoryConnectorFactories);
    }

    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        Session ns;
        String url;
        Optional nso;
        boolean connectorSkip = ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{"njord.connector.skip"});
        if (!connectorSkip && (nso = NjordUtils.mayGetNjordSession((RepositorySystemSession)session)).isPresent() && ((Session)nso.orElseThrow(J8Utils.OET)).config().enabled() && (url = (ns = (Session)nso.orElseThrow(J8Utils.OET)).artifactPublisherRedirector().getRepositoryUrl(repository)) != null && url.startsWith("njord:")) {
            RepositoryConnectorFactory basicRepositoryConnectorFactory = Objects.requireNonNull((RepositoryConnectorFactory)this.repositoryConnectorFactories.get("basic").get(), "No basic repository connector factory found");
            ArtifactStore artifactStore = ns.getOrCreateSessionArtifactStore(url.substring(6));
            return new NjordRepositoryConnector(artifactStore, repository, basicRepositoryConnectorFactory.newInstance(artifactStore.storeRepositorySession(session), artifactStore.storeRemoteRepository()));
        }
        throw new NoRepositoryConnectorException(repository);
    }

    public float getPriority() {
        return 10.0f;
    }
}

