/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.publisher.deploy;

import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.impl.store.ArtifactStoreDeployer;
import eu.maveniverse.maven.njord.shared.publisher.ArtifactStorePublisherSupport;
import eu.maveniverse.maven.njord.shared.publisher.ArtifactStoreRequirements;
import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public class DeployPublisher
extends ArtifactStorePublisherSupport {
    public DeployPublisher(Session session, RepositorySystem repositorySystem, RemoteRepository releasesRepository, RemoteRepository snapshotsRepository, ArtifactStoreRequirements artifactStoreRequirements) {
        super(session, repositorySystem, "deploy", "Publishes to any repository just like maven-deploy-plugin would", releasesRepository, snapshotsRepository, releasesRepository, snapshotsRepository, artifactStoreRequirements);
    }

    protected void doPublish(ArtifactStore artifactStore) throws IOException {
        RemoteRepository repository = this.selectRemoteRepositoryFor(artifactStore);
        if (this.session.config().dryRun()) {
            this.logger.info("Dry run; not publishing to '{}' service at {}", (Object)this.name, (Object)repository.getUrl());
            return;
        }
        RemoteRepository authSource = this.repositorySystem.newDeploymentRepository(this.session.config().session(), this.session.artifactPublisherRedirector().getAuthRepositoryId(repository));
        if (!Objects.equals(repository.getId(), authSource.getId())) {
            repository = new RemoteRepository.Builder(repository).setAuthentication(authSource.getAuthentication()).setProxy(repository.getProxy()).build();
        }
        try (ArtifactStore store = artifactStore;){
            new ArtifactStoreDeployer(this.repositorySystem, (RepositorySystemSession)new DefaultRepositorySystemSession(this.session.config().session()).setConfigProperty("njord.connector.skip", (Object)true), repository, true).deploy(store);
        }
    }
}

