/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.publisher.deploy;

import eu.maveniverse.maven.njord.publisher.deploy.DeployPublisher;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.SessionConfig;
import eu.maveniverse.maven.njord.shared.impl.J8Utils;
import eu.maveniverse.maven.njord.shared.impl.ResolverUtils;
import eu.maveniverse.maven.njord.shared.publisher.ArtifactStorePublisher;
import eu.maveniverse.maven.njord.shared.publisher.ArtifactStorePublisherFactory;
import eu.maveniverse.maven.njord.shared.publisher.ArtifactStoreRequirements;
import eu.maveniverse.maven.njord.shared.store.RepositoryMode;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;

@Singleton
@Named(value="deploy")
public class DeployPublisherFactory
implements ArtifactStorePublisherFactory {
    public static final String NAME = "deploy";
    private static final String PROP_ALT_DEPLOYMENT_REPOSITORY = "altDeploymentRepository";
    private final RepositorySystem repositorySystem;

    @Inject
    public DeployPublisherFactory(RepositorySystem repositorySystem) {
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
    }

    public ArtifactStorePublisher create(Session session) {
        Objects.requireNonNull(session);
        RemoteRepository releasesRepository = null;
        RemoteRepository snapshotsRepository = null;
        if (session.config().effectiveProperties().containsKey(PROP_ALT_DEPLOYMENT_REPOSITORY)) {
            String altDeploymentRepository = (String)session.config().effectiveProperties().get(PROP_ALT_DEPLOYMENT_REPOSITORY);
            RemoteRepository bare = ResolverUtils.parseRemoteRepositoryString((String)altDeploymentRepository);
            releasesRepository = new RemoteRepository.Builder(bare).setSnapshotPolicy(new RepositoryPolicy(false, null, null)).build();
            snapshotsRepository = new RemoteRepository.Builder(bare).setReleasePolicy(new RepositoryPolicy(false, null, null)).build();
        } else if (session.config().currentProject().isPresent()) {
            SessionConfig.CurrentProject project = (SessionConfig.CurrentProject)session.config().currentProject().orElseThrow(J8Utils.OET);
            releasesRepository = (RemoteRepository)project.distributionManagementRepositories().get(RepositoryMode.RELEASE);
            snapshotsRepository = (RemoteRepository)project.distributionManagementRepositories().get(RepositoryMode.SNAPSHOT);
        }
        return new DeployPublisher(session, this.repositorySystem, releasesRepository, snapshotsRepository, ArtifactStoreRequirements.NONE);
    }
}

