/*
 * Decompiled with CFR 0.152.
 */
package eu.maneniverse.maven.plugins.bombuilder;

import eu.maneniverse.maven.plugins.bombuilder.BomExclusion;
import eu.maneniverse.maven.plugins.bombuilder.DependencyExclusion;
import eu.maneniverse.maven.plugins.bombuilder.PomDependencyVersionsTransformer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="build-bom", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class BuildBomMojo
extends AbstractMojo {
    private static final String VERSION_PROPERTY_PREFIX = "version.";
    @Parameter
    private String bomParentGav;
    @Parameter(required=true, property="bom.groupId", defaultValue="${project.groupId}")
    private String bomGroupId;
    @Parameter(required=true, property="bom.artifactId", defaultValue="${project.artifactId}")
    private String bomArtifactId;
    @Parameter(required=true, property="bom.version", defaultValue="${project.version}")
    private String bomVersion;
    @Parameter(property="bom.name")
    private String bomName;
    @Parameter(property="bom.description")
    private String bomDescription;
    @Parameter(property="bom.classifier")
    private String bomClassifier;
    @Parameter(property="bom.inheritFrom", defaultValue="top")
    private String inheritFrom;
    @Parameter
    private boolean addVersionProperties;
    @Parameter(property="bom.usePropertiesForVersion")
    boolean usePropertiesForVersion;
    @Parameter(defaultValue="bom-pom.xml")
    String outputFilename;
    @Parameter
    private List<BomExclusion> exclusions;
    @Parameter
    private List<DependencyExclusion> dependencyExclusions;
    @Parameter
    private List<DependencyExclusion> dependencyInclusions;
    @Parameter(property="bom.reactorDependencies", defaultValue="REACTOR")
    Scope reactorDependencies;
    @Parameter(property="bom.directDependencies", defaultValue="NONE")
    Scope directDependencies;
    @Parameter(property="bom.transitiveDependencies", defaultValue="NONE")
    Scope transitiveDependencies;
    @Parameter(property="bom.includePoms")
    boolean includePoms;
    @Parameter(property="bom.useProjectParentAsParent")
    boolean useProjectParentAsParent;
    @Parameter(property="bom.attach")
    boolean attach;
    @Parameter(defaultValue="${session}")
    MavenSession mavenSession;
    @Parameter(defaultValue="${session.allProjects}")
    List<MavenProject> allProjects;
    @Component
    MavenProjectHelper mavenProjectHelper;
    private final PomDependencyVersionsTransformer versionsTransformer;
    private final ModelWriter modelWriter;

    public BuildBomMojo() {
        this(new ModelWriter(), new PomDependencyVersionsTransformer());
    }

    BuildBomMojo(ModelWriter modelWriter, PomDependencyVersionsTransformer versionsTransformer) {
        this.versionsTransformer = versionsTransformer;
        this.modelWriter = modelWriter;
    }

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating BOM");
        Model model = this.initializeModel();
        this.addDependencyManagement(model);
        if (this.usePropertiesForVersion) {
            model = this.versionsTransformer.transformPomModel(model);
            this.getLog().debug((CharSequence)"Dependencies versions converted to properties");
        }
        MavenProject mavenProject = this.mavenSession.getCurrentProject();
        Path outputFile = Paths.get(mavenProject.getBuild().getDirectory(), new String[0]).resolve(this.outputFilename);
        this.modelWriter.writeModel(model, outputFile.toFile());
        if (this.attach) {
            if (this.bomClassifier != null && !this.bomClassifier.trim().isEmpty()) {
                this.getLog().debug((CharSequence)("Attaching BOM w/ classifier: " + this.bomClassifier));
                DefaultArtifact artifact = new DefaultArtifact(this.bomGroupId, this.bomArtifactId, this.bomVersion, null, "pom", this.bomClassifier, (ArtifactHandler)new PomArtifactHandler());
                artifact.setFile(outputFile.toFile());
                mavenProject.addAttachedArtifact((Artifact)artifact);
            } else if (Objects.equals("pom", mavenProject.getPackaging()) && mavenProject.getModules().isEmpty()) {
                this.getLog().debug((CharSequence)"Replacing module POM w/ generated BOM");
                mavenProject.setFile(outputFile.toFile());
            } else {
                throw new MojoExecutionException("Cannot replace project POM: invalid project (packaging=pom w/o modules)");
            }
        }
    }

    private Model initializeModel() throws MojoExecutionException {
        MavenProject mavenProject = this.mavenSession.getCurrentProject();
        Model pomModel = new Model();
        pomModel.setModelVersion("4.0.0");
        if (this.bomParentGav != null) {
            String[] gav = this.bomParentGav.split(":");
            if (gav.length != 3) {
                throw new MojoExecutionException("BOM parent should be specified as [groupId]:[artifactId]:[version] but is '" + this.bomParentGav + "'");
            }
            Parent parent = new Parent();
            parent.setGroupId(gav[0]);
            parent.setArtifactId(gav[1]);
            parent.setVersion(gav[2]);
            pomModel.setParent(parent);
        } else if (this.useProjectParentAsParent && mavenProject.getModel().getParent() != null) {
            pomModel.setParent(mavenProject.getModel().getParent());
            pomModel.getParent().setRelativePath(null);
        }
        pomModel.setGroupId(this.bomGroupId);
        pomModel.setArtifactId(this.bomArtifactId);
        pomModel.setVersion(this.bomVersion);
        pomModel.setPackaging("pom");
        if (this.bomName != null) {
            pomModel.setName(this.bomName);
        }
        if (this.bomDescription != null) {
            pomModel.setDescription(this.bomDescription);
        }
        if (this.attach && !this.useProjectParentAsParent && (this.bomClassifier == null || this.bomClassifier.trim().isEmpty())) {
            if ("top".equals(this.inheritFrom)) {
                mavenProject = this.mavenSession.getTopLevelProject();
            } else if ("this".equals(this.inheritFrom)) {
                mavenProject = this.mavenSession.getCurrentProject();
            } else {
                throw new MojoExecutionException("Invalid value for parameter inheritFrom: \"" + this.inheritFrom + "\"; Supported values are \"top\" (default) and \"this\"");
            }
            if (this.bomName == null) {
                pomModel.setName(mavenProject.getModel().getName());
            }
            if (this.bomDescription == null) {
                pomModel.setDescription(mavenProject.getModel().getDescription());
            }
            pomModel.setUrl(mavenProject.getModel().getUrl());
            pomModel.setLicenses(mavenProject.getModel().getLicenses());
            pomModel.setDevelopers(mavenProject.getModel().getDevelopers());
            pomModel.setScm(mavenProject.getModel().getScm());
        }
        return pomModel;
    }

    private void addDependencyManagement(Model pomModel) {
        MavenProject mavenProject = this.mavenSession.getCurrentProject();
        HashSet<Artifact> projectArtifactsSet = new HashSet<Artifact>();
        if (this.reactorDependencies == Scope.REACTOR) {
            for (MavenProject prj : this.allProjects) {
                if (!this.includePoms && "pom".equals(prj.getArtifact().getType())) continue;
                projectArtifactsSet.add(prj.getArtifact());
            }
        } else if (this.reactorDependencies == Scope.CURRENT_PROJECT && (this.includePoms || !"pom".equals(mavenProject.getArtifact().getType()))) {
            projectArtifactsSet.add(mavenProject.getArtifact());
        }
        if (this.directDependencies == Scope.REACTOR) {
            for (MavenProject prj : this.allProjects) {
                if (!this.includePoms && "pom".equals(prj.getArtifact().getType())) continue;
                projectArtifactsSet.addAll(prj.getDependencyArtifacts());
            }
        } else if (this.directDependencies == Scope.CURRENT_PROJECT) {
            projectArtifactsSet.addAll(mavenProject.getDependencyArtifacts());
        }
        if (this.transitiveDependencies == Scope.REACTOR) {
            for (MavenProject prj : this.allProjects) {
                if (!this.includePoms && "pom".equals(prj.getArtifact().getType())) continue;
                prj.setArtifactFilter(a -> !"test".equals(a.getScope()));
                projectArtifactsSet.addAll(prj.getArtifacts());
            }
        } else if (this.transitiveDependencies == Scope.CURRENT_PROJECT) {
            mavenProject.setArtifactFilter(a -> !"test".equals(a.getScope()));
            projectArtifactsSet.addAll(mavenProject.getArtifacts());
        }
        ArrayList projectArtifacts = new ArrayList(projectArtifactsSet);
        Collections.sort(projectArtifacts);
        LinkedHashMap<String, String> versionProperties = new LinkedHashMap<String, String>();
        DependencyManagement depMgmt = new DependencyManagement();
        for (Artifact artifact : projectArtifacts) {
            if (!this.isIncludedDependency(artifact) || this.isExcludedDependency(artifact)) continue;
            String versionPropertyName = VERSION_PROPERTY_PREFIX + artifact.getGroupId();
            if (versionProperties.get(versionPropertyName) != null && !((String)versionProperties.get(versionPropertyName)).equals(artifact.getVersion())) {
                versionPropertyName = VERSION_PROPERTY_PREFIX + artifact.getGroupId() + "." + artifact.getArtifactId();
            }
            versionProperties.put(versionPropertyName, artifact.getVersion());
            Dependency dep = new Dependency();
            dep.setGroupId(artifact.getGroupId());
            dep.setArtifactId(artifact.getArtifactId());
            dep.setVersion(artifact.getVersion());
            if (!StringUtils.isEmpty((String)artifact.getClassifier())) {
                dep.setClassifier(artifact.getClassifier());
            }
            if (!StringUtils.isEmpty((String)artifact.getType())) {
                dep.setType(artifact.getType());
            }
            if (this.exclusions != null) {
                this.applyExclusions(artifact, dep);
            }
            depMgmt.addDependency(dep);
        }
        pomModel.setDependencyManagement(depMgmt);
        if (this.addVersionProperties) {
            Properties props = pomModel.getProperties();
            for (Map.Entry entry : versionProperties.entrySet()) {
                props.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.getLog().debug((CharSequence)("Added " + projectArtifacts.size() + " dependencies."));
    }

    boolean isIncludedDependency(Artifact artifact) {
        if (this.dependencyInclusions == null || this.dependencyInclusions.isEmpty()) {
            return true;
        }
        for (DependencyExclusion inclusion : this.dependencyInclusions) {
            if (!this.matchesExcludedDependency(artifact, inclusion)) continue;
            this.getLog().debug((CharSequence)("Artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " matches included dependency " + inclusion.getGroupId() + ":" + inclusion.getArtifactId()));
            return true;
        }
        return false;
    }

    boolean isExcludedDependency(Artifact artifact) {
        if (this.dependencyExclusions == null || this.dependencyExclusions.isEmpty()) {
            return false;
        }
        for (DependencyExclusion exclusion : this.dependencyExclusions) {
            if (!this.matchesExcludedDependency(artifact, exclusion)) continue;
            this.getLog().debug((CharSequence)("Artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " matches excluded dependency " + exclusion.getGroupId() + ":" + exclusion.getArtifactId()));
            return true;
        }
        return false;
    }

    boolean matchesExcludedDependency(Artifact artifact, DependencyExclusion exclusion) {
        String groupId = this.defaultAndTrim(artifact.getGroupId());
        String artifactId = this.defaultAndTrim(artifact.getArtifactId());
        String exclusionGroupId = this.defaultAndTrim(exclusion.getGroupId());
        String exclusionArtifactId = this.defaultAndTrim(exclusion.getArtifactId());
        boolean groupIdMatched = "*".equals(exclusionGroupId) || groupId.equals(exclusionGroupId);
        boolean artifactIdMatched = "*".equals(exclusionArtifactId) || artifactId.equals(exclusionArtifactId);
        return groupIdMatched && artifactIdMatched;
    }

    private String defaultAndTrim(String string) {
        return Objects.toString(StringUtils.trim((String)string), "");
    }

    private void applyExclusions(Artifact artifact, Dependency dep) {
        for (BomExclusion exclusion : this.exclusions) {
            if (!exclusion.getDependencyGroupId().equals(artifact.getGroupId()) || !exclusion.getDependencyArtifactId().equals(artifact.getArtifactId())) continue;
            Exclusion ex = new Exclusion();
            ex.setGroupId(exclusion.getExclusionGroupId());
            ex.setArtifactId(exclusion.getExclusionArtifactId());
            dep.addExclusion(ex);
        }
    }

    static class ModelWriter {
        ModelWriter() {
        }

        void writeModel(Model pomModel, File outputFile) throws MojoExecutionException {
            if (!outputFile.getParentFile().exists()) {
                outputFile.getParentFile().mkdirs();
            }
            try (OutputStream outputStream = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);){
                MavenXpp3Writer mavenWriter = new MavenXpp3Writer();
                mavenWriter.write(outputStream, pomModel);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to write pom file.", (Exception)e);
            }
        }
    }

    static class PomArtifactHandler
    implements ArtifactHandler {
        PomArtifactHandler() {
        }

        public String getClassifier() {
            return null;
        }

        public String getDirectory() {
            return null;
        }

        public String getExtension() {
            return "pom";
        }

        public String getLanguage() {
            return "none";
        }

        public String getPackaging() {
            return "pom";
        }

        public boolean isAddedToClasspath() {
            return false;
        }

        public boolean isIncludesDependencies() {
            return false;
        }
    }

    public static enum Scope {
        NONE,
        REACTOR,
        CURRENT_PROJECT;

    }
}

