/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.plugin3;

import eu.maveniverse.maven.njord.plugin3.NjordMojoSupport;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.impl.J8Utils;
import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import eu.maveniverse.maven.njord.shared.store.ArtifactStoreComparator;
import java.io.IOException;
import java.util.Optional;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="compare", threadSafe=true, requiresProject=false, aggregator=true)
public class CompareMojo
extends NjordMojoSupport {
    @Parameter(required=true, property="store1")
    private String store1;
    @Parameter(required=true, property="store2")
    private String store2;
    @Parameter(required=true, property="comparator", defaultValue="bitwise")
    private String comparator;
    @Parameter(required=true, property="details", defaultValue="false")
    private boolean details;

    @Override
    protected void doWithSession(Session ns) throws IOException, MojoFailureException {
        block17: {
            Optional store1Optional = ns.artifactStoreManager().selectArtifactStore(this.store1);
            if (!store1Optional.isPresent()) {
                this.logger.warn("ArtifactStore with given name not found: {}", (Object)this.store1);
                return;
            }
            Optional store2Optional = ns.artifactStoreManager().selectArtifactStore(this.store2);
            if (!store2Optional.isPresent()) {
                this.logger.warn("ArtifactStore with given name not found: {}", (Object)this.store2);
                return;
            }
            Optional po = ns.selectArtifactStoreComparator(this.comparator);
            if (po.isPresent()) {
                ArtifactStoreComparator p = (ArtifactStoreComparator)po.orElseThrow(J8Utils.OET);
                try (ArtifactStore one = (ArtifactStore)store1Optional.orElseThrow(J8Utils.OET);
                     ArtifactStore two = (ArtifactStore)store2Optional.orElseThrow(J8Utils.OET);){
                    ArtifactStoreComparator.ComparisonResult vr = p.compare(one, two);
                    if (this.details) {
                        this.logger.info("Comparison results for {} vs {}", (Object)this.store1, (Object)this.store2);
                        this.dumpComparisonResult("", vr);
                    }
                    if (!vr.isEqual()) {
                        this.logger.error("ArtifactStore {} and {} are DIFFERENT", (Object)this.store1, (Object)this.store2);
                        throw new MojoFailureException("ArtifactStore comparison failed");
                    }
                    this.logger.info("ArtifactStore {} and {} are EQUAL", (Object)this.store1, (Object)this.store2);
                    break block17;
                }
            }
            throw new MojoFailureException("Comparator not found");
        }
    }

    private void dumpComparisonResult(String prefix, ArtifactStoreComparator.ComparisonResult vr) {
        this.logger.info("{} {}", (Object)prefix, (Object)vr.name());
        if (!vr.differences().isEmpty()) {
            for (String msg : vr.differences()) {
                this.logger.warn("{}    {}", (Object)prefix, (Object)msg);
            }
        }
        if (!vr.equalities().isEmpty()) {
            for (String msg : vr.equalities()) {
                this.logger.info("{}    {}", (Object)prefix, (Object)msg);
            }
        }
        for (ArtifactStoreComparator.ComparisonResult child : vr.children()) {
            this.dumpComparisonResult(prefix + "  ", child);
        }
    }
}

