/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.plugin3;

import eu.maveniverse.maven.njord.plugin3.NjordMojoSupport;
import eu.maveniverse.maven.njord.shared.Session;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="drop-all", threadSafe=true, requiresProject=false, aggregator=true)
public class DropAllMojo
extends NjordMojoSupport {
    @Parameter(required=true, property="yes")
    private boolean yes;

    @Override
    protected void doWithSession(Session ns) throws IOException {
        if (this.yes) {
            this.logger.info("Dropping all ArtifactStore");
            AtomicInteger count = new AtomicInteger();
            for (String name : ns.artifactStoreManager().listArtifactStoreNames()) {
                if (!ns.artifactStoreManager().dropArtifactStore(name)) continue;
                this.logger.info("{}. dropped {}", (Object)count.incrementAndGet(), (Object)name);
            }
            this.logger.info("Dropped total of {} ArtifactStore", (Object)count.get());
        } else {
            this.logger.warn("Not dropping all: you must add extra `-Dyes` to agree on consequences");
        }
    }
}

