/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.plugin3;

import eu.maveniverse.maven.njord.plugin3.NjordMojoSupport;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.impl.J8Utils;
import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import eu.maveniverse.maven.shared.core.fs.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="export-all", threadSafe=true, requiresProject=false, aggregator=true)
public class ExportAllMojo
extends NjordMojoSupport {
    @Parameter(required=true, property="path", defaultValue=".")
    private String path;

    @Override
    protected void doWithSession(Session ns) throws IOException, MojoExecutionException {
        Path targetPath = FileUtils.canonicalPath((Path)Paths.get(this.path, new String[0]).toAbsolutePath());
        Files.createDirectories(targetPath, new FileAttribute[0]);
        for (String name : ns.artifactStoreManager().listArtifactStoreNames()) {
            Optional storeOptional = ns.artifactStoreManager().selectArtifactStore(name);
            if (!storeOptional.isPresent()) continue;
            this.logger.info("Exporting store {} to {}", (Object)name, (Object)targetPath);
            Path bundle = ns.artifactStoreManager().exportTo((ArtifactStore)storeOptional.orElseThrow(J8Utils.OET), targetPath);
            this.logger.info("Exported to " + bundle);
        }
    }
}

