/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.plugin3;

import eu.maveniverse.maven.njord.plugin3.NjordMojoSupport;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.impl.J8Utils;
import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import eu.maveniverse.maven.shared.core.fs.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="export", threadSafe=true, requiresProject=false, aggregator=true)
public class ExportMojo
extends NjordMojoSupport {
    @Parameter(required=true, property="store")
    private String store;
    @Parameter(required=true, property="path", defaultValue=".")
    private String path;

    @Override
    protected void doWithSession(Session ns) throws IOException, MojoExecutionException {
        Optional storeOptional = ns.artifactStoreManager().selectArtifactStore(this.store);
        if (storeOptional.isPresent()) {
            Path targetPath = FileUtils.canonicalPath((Path)Paths.get(this.path, new String[0]).toAbsolutePath());
            this.logger.info("Exporting store {} to {}", (Object)this.store, (Object)targetPath);
            Path bundle = ns.artifactStoreManager().exportTo((ArtifactStore)storeOptional.orElseThrow(J8Utils.OET), targetPath);
            this.logger.info("Exported to " + bundle);
        } else {
            this.logger.warn("ArtifactStore with given name not found");
        }
    }
}

