/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.plugin3;

import eu.maveniverse.maven.njord.plugin3.NjordMojoSupport;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import eu.maveniverse.maven.shared.core.fs.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="import-all", threadSafe=true, requiresProject=false, aggregator=true)
public class ImportAllMojo
extends NjordMojoSupport {
    @Parameter(required=true, property="dir", defaultValue=".")
    private String dir;

    @Override
    protected void doWithSession(Session ns) throws IOException, MojoExecutionException {
        List bundles;
        Path sourceDirectory = FileUtils.canonicalPath((Path)Paths.get(this.dir, new String[0]).toAbsolutePath());
        if (!Files.isDirectory(sourceDirectory, new LinkOption[0])) {
            throw new MojoExecutionException("Import directory does not exist");
        }
        this.logger.info("Importing stores from {}", (Object)sourceDirectory);
        try (Stream<Path> stream = Files.list(sourceDirectory).filter(p -> p.getFileName().toString().endsWith(".ntb") && Files.isRegularFile(p, new LinkOption[0]));){
            bundles = stream.collect(Collectors.toList());
        }
        for (Path bundle : bundles) {
            ArtifactStore artifactStore = ns.artifactStoreManager().importFrom(bundle);
            try {
                this.logger.info("Imported to " + artifactStore);
            }
            finally {
                if (artifactStore == null) continue;
                artifactStore.close();
            }
        }
    }
}

