/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.plugin3;

import eu.maveniverse.maven.njord.plugin3.NjordMojoSupport;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import eu.maveniverse.maven.shared.core.fs.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="import", threadSafe=true, requiresProject=false, aggregator=true)
public class ImportMojo
extends NjordMojoSupport {
    @Parameter(required=true, property="file")
    private String file;

    @Override
    protected void doWithSession(Session ns) throws IOException, MojoExecutionException {
        Path source = FileUtils.canonicalPath((Path)Paths.get(this.file, new String[0]).toAbsolutePath());
        if (!Files.exists(source, new LinkOption[0])) {
            throw new MojoExecutionException("Import file not found: " + this.file);
        }
        this.logger.info("Importing store from {}", (Object)source);
        try (ArtifactStore artifactStore = ns.artifactStoreManager().importFrom(source);){
            this.logger.info("Imported to " + artifactStore);
        }
    }
}

