/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.plugin3;

import eu.maveniverse.maven.njord.plugin3.NjordMojoSupport;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.impl.J8Utils;
import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

@Mojo(name="list-content", threadSafe=true, requiresProject=false, aggregator=true)
public class ListContentMojo
extends NjordMojoSupport {
    @Parameter(required=true, property="store")
    private String store;

    @Override
    protected void doWithSession(Session ns) throws IOException {
        Optional storeOptional = ns.artifactStoreManager().selectArtifactStore(this.store);
        if (storeOptional.isPresent()) {
            try (ArtifactStore store = (ArtifactStore)storeOptional.orElseThrow(J8Utils.OET);){
                this.logger.info("List contents of ArtifactStore {}", (Object)store);
                AtomicInteger counter = new AtomicInteger();
                for (Artifact artifact : store.artifacts()) {
                    this.logger.info("{}. {}", (Object)counter.incrementAndGet(), (Object)ArtifactIdUtils.toId((Artifact)artifact));
                }
            }
        } else {
            this.logger.warn("ArtifactStore with given name not found");
        }
    }
}

