/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.plugin3;

import eu.maveniverse.maven.njord.plugin3.NjordMojoSupport;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.impl.J8Utils;
import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import eu.maveniverse.maven.njord.shared.store.ArtifactStoreMerger;
import eu.maveniverse.maven.njord.shared.store.ArtifactStoreTemplate;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

@Mojo(name="merge-all", threadSafe=true, requiresProject=false, aggregator=true)
public class MergeAllMojo
extends NjordMojoSupport {
    @Parameter(required=true, property="failIfNothingDone", defaultValue="true")
    private boolean failIfNothingDone;
    @Parameter(property="originProjectGav")
    private String originProjectGav;

    @Override
    protected void doWithSession(Session ns) throws IOException, MojoExecutionException {
        String targetName;
        ArtifactStoreTemplate template = null;
        DefaultArtifact originProjectArtifact = this.originProjectGav != null ? new DefaultArtifact(this.originProjectGav) : null;
        HashSet<String> names = new HashSet<String>();
        for (String name : ns.artifactStoreManager().listArtifactStoreNames()) {
            Optional so = ns.artifactStoreManager().selectArtifactStore(name);
            if (!so.isPresent()) continue;
            names.add(name);
            ArtifactStore store = (ArtifactStore)so.orElseThrow(J8Utils.OET);
            try {
                if (template == null) {
                    template = store.template();
                } else if (!template.equals((Object)store.template())) {
                    throw new MojoExecutionException("Conflicting templates used");
                }
                if (originProjectArtifact != null) continue;
                originProjectArtifact = store.originProjectArtifact().orElse(null);
            }
            finally {
                if (store == null) continue;
                store.close();
            }
        }
        if (template == null) {
            if (this.failIfNothingDone) {
                throw new MojoExecutionException("Nothing to merge");
            }
            return;
        }
        try (ArtifactStore target = ns.artifactStoreManager().createArtifactStore(template, (Artifact)originProjectArtifact);){
            this.logger.info("Created target store {}", (Object)target);
            targetName = target.name();
        }
        ArtifactStoreMerger merger = ns.artifactStoreMerger();
        for (String name : names) {
            Optional so = ns.artifactStoreManager().selectArtifactStore(name);
            if (so.isPresent()) {
                try (ArtifactStore source = (ArtifactStore)so.orElseThrow(J8Utils.OET);
                     ArtifactStore target = (ArtifactStore)ns.artifactStoreManager().selectArtifactStore(targetName).orElseThrow(J8Utils.OET);){
                    merger.merge(source, target);
                }
                this.logger.info("Dropping {}", (Object)name);
                ns.artifactStoreManager().dropArtifactStore(name);
                continue;
            }
            throw new MojoExecutionException("Once found store is gone: " + name);
        }
        this.logger.info("Renumbering stores");
        ns.artifactStoreManager().renumberArtifactStores();
    }
}

