/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.plugin3;

import eu.maveniverse.maven.njord.shared.NjordUtils;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.SessionConfig;
import eu.maveniverse.maven.njord.shared.SessionFactory;
import eu.maveniverse.maven.njord.shared.impl.J8Utils;
import eu.maveniverse.maven.njord.shared.publisher.ArtifactStorePublisher;
import eu.maveniverse.maven.njord.shared.publisher.ArtifactStoreRequirements;
import eu.maveniverse.maven.njord.shared.publisher.spi.signature.SignatureType;
import eu.maveniverse.maven.njord.shared.store.ArtifactStoreTemplate;
import eu.maveniverse.maven.shared.plugin.MojoSupport;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;

public abstract class NjordMojoSupport
extends MojoSupport {
    @Inject
    protected MavenSession mavenSession;
    @Inject
    private SessionFactory sessionFactory;

    public void executeMojo() throws MojoExecutionException, MojoFailureException {
        try {
            Optional njordSession = NjordUtils.mayGetNjordSession((RepositorySystemSession)this.mavenSession.getRepositorySession());
            if (!njordSession.isPresent()) {
                this.doWithoutSession();
            } else {
                this.doWithSession((Session)njordSession.orElseThrow(J8Utils.OET));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected abstract void doWithSession(Session var1) throws IOException, MojoExecutionException, MojoFailureException;

    protected void doWithoutSession() throws IOException, MojoExecutionException, MojoFailureException {
        this.logger.warn("Njord extension is not installed; continuing with creating temporary session");
        SessionConfig sc = SessionConfig.defaults((RepositorySystemSession)this.mavenSession.getRepositorySession(), (List)RepositoryUtils.toRepos((List)this.mavenSession.getRequest().getRemoteRepositories())).currentProject(SessionConfig.fromMavenProject((MavenProject)this.mavenSession.getTopLevelProject())).build();
        if (sc.enabled()) {
            try (Session ns = NjordUtils.lazyInit((SessionConfig)sc, arg_0 -> ((SessionFactory)this.sessionFactory).create(arg_0));){
                this.doWithSession(ns);
            }
        } else {
            throw new MojoExecutionException("Njord is disabled");
        }
    }

    protected void printTemplate(ArtifactStoreTemplate template, boolean defaultTemplate) {
        this.logger.info("- {} {}", (Object)template.name(), (Object)(defaultTemplate ? " (default " + template.repositoryMode().name() + ")" : " "));
        this.logger.info("    Default prefix: '{}'", (Object)template.prefix());
        this.logger.info("    Allow redeploy: {}", (Object)template.allowRedeploy());
        this.logger.info("    Checksum Factories: {}", template.checksumAlgorithmFactories().isPresent() ? template.checksumAlgorithmFactories().orElseThrow(J8Utils.OET) : "Globally configured");
        this.logger.info("    Omit checksums for: {}", template.omitChecksumsForExtensions().isPresent() ? template.omitChecksumsForExtensions().orElseThrow(J8Utils.OET) : "Globally configured");
    }

    protected void printPublisher(ArtifactStorePublisher publisher) {
        this.logger.info("- '{}' -> {}", (Object)publisher.name(), (Object)publisher.description());
        if (publisher.targetReleaseRepository().isPresent() || publisher.targetSnapshotRepository().isPresent()) {
            ArtifactStoreRequirements artifactStoreRequirements = publisher.artifactStoreRequirements();
            this.logger.info("  Checksums:");
            this.logger.info("    Mandatory: {}", (Object)(!artifactStoreRequirements.mandatoryChecksumAlgorithms().isPresent() ? "No checksum requirements set" : ((List)artifactStoreRequirements.mandatoryChecksumAlgorithms().orElseThrow(J8Utils.OET)).stream().map(ChecksumAlgorithmFactory::getName).collect(Collectors.joining(", "))));
            this.logger.info("    Supported: {}", (Object)(!artifactStoreRequirements.optionalChecksumAlgorithms().isPresent() ? "No checksum requirements set" : ((List)artifactStoreRequirements.optionalChecksumAlgorithms().orElseThrow(J8Utils.OET)).stream().map(ChecksumAlgorithmFactory::getName).collect(Collectors.joining(", "))));
            this.logger.info("  Signatures:");
            this.logger.info("    Mandatory: {}", (Object)(!artifactStoreRequirements.mandatorySignatureTypes().isPresent() ? "No signature requirements set" : ((List)artifactStoreRequirements.mandatorySignatureTypes().orElseThrow(J8Utils.OET)).stream().map(SignatureType::name).collect(Collectors.joining(", "))));
            this.logger.info("    Supported: {}", (Object)(!artifactStoreRequirements.optionalSignatureTypes().isPresent() ? "No signature requirements set" : ((List)artifactStoreRequirements.optionalSignatureTypes().orElseThrow(J8Utils.OET)).stream().map(SignatureType::name).collect(Collectors.joining(", "))));
            this.logger.info("  Published artifacts will be available from:");
            this.logger.info("    RELEASES:  {}", (Object)this.fmt(publisher.targetReleaseRepository().orElse(null)));
            this.logger.info("    SNAPSHOTS: {}", (Object)this.fmt(publisher.targetSnapshotRepository().orElse(null)));
        }
        this.logger.info("  Service endpoints:");
        this.logger.info("    RELEASES:  {}", (Object)this.fmt(publisher.serviceReleaseRepository().orElse(null)));
        this.logger.info("    SNAPSHOTS: {}", (Object)this.fmt(publisher.serviceSnapshotRepository().orElse(null)));
    }

    private String fmt(RemoteRepository repo) {
        if (repo == null) {
            return "n/a";
        }
        return repo.getId() + " @ " + repo.getUrl();
    }
}

