/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.plugin3;

import eu.maveniverse.maven.njord.plugin3.NjordMojoSupport;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.impl.J8Utils;
import eu.maveniverse.maven.njord.shared.publisher.ArtifactStorePublisher;
import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class PublisherSupportMojo
extends NjordMojoSupport {
    @Parameter(property="store")
    protected String store;
    @Parameter(property="publisher")
    protected String publisher;

    protected List<String> getArtifactStoreNameCandidates(Session ns) throws IOException {
        if (this.store == null && ns.config().prefix().isPresent()) {
            String prefix = (String)ns.config().prefix().orElseThrow(J8Utils.OET);
            return ns.artifactStoreManager().listArtifactStoreNamesForPrefix(prefix);
        }
        if (this.store != null) {
            return Collections.singletonList(this.store);
        }
        return Collections.emptyList();
    }

    protected Optional<String> getArtifactStoreName(Session ns) throws IOException {
        List<String> storeNames = this.getArtifactStoreNameCandidates(ns);
        if (!storeNames.isEmpty()) {
            if (storeNames.size() == 1) {
                this.store = storeNames.get(0);
                this.logger.info("Found one store, using it: '{}'", (Object)this.store);
            } else {
                this.store = storeNames.get(storeNames.size() - 1);
                this.logger.info("Found multiple stores, using latest: '{}'", (Object)this.store);
            }
            return Optional.of(this.store);
        }
        return Optional.empty();
    }

    protected ArtifactStore getArtifactStore(Session ns) throws IOException, MojoFailureException {
        Optional<String> storeName = this.getArtifactStoreName(ns);
        if (!storeName.isPresent()) {
            throw new MojoFailureException("ArtifactStore name was not specified nor could be found");
        }
        String store = storeName.orElseThrow(J8Utils.OET);
        Optional storeOptional = ns.artifactStoreManager().selectArtifactStore(store);
        if (!storeOptional.isPresent()) {
            this.logger.warn("ArtifactStore with given name not found: {}", (Object)store);
            throw new MojoFailureException("ArtifactStore with given name not found: " + store);
        }
        return (ArtifactStore)storeOptional.orElseThrow(J8Utils.OET);
    }

    protected Optional<String> getArtifactStorePublisherName(Session ns) {
        if (this.publisher != null) {
            return Optional.of(this.publisher);
        }
        return ns.artifactPublisherRedirector().getArtifactStorePublisherName();
    }

    protected ArtifactStorePublisher getArtifactStorePublisher(Session ns) throws MojoFailureException {
        Optional<String> publisherName = this.getArtifactStorePublisherName(ns);
        if (!publisherName.isPresent()) {
            throw new MojoFailureException("Publisher name was not specified nor could be discovered");
        }
        String publisher = publisherName.orElseThrow(J8Utils.OET);
        Optional po = ns.selectArtifactStorePublisher(publisher);
        if (!po.isPresent()) {
            throw new MojoFailureException("Publisher not found: " + publisher);
        }
        return (ArtifactStorePublisher)po.orElseThrow(J8Utils.OET);
    }
}

