/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.plugin3;

import eu.maveniverse.maven.njord.plugin3.NjordMojoSupport;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.impl.J8Utils;
import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import java.io.IOException;
import java.util.Optional;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="redeploy", threadSafe=true, requiresProject=false, aggregator=true)
public class RedeployMojo
extends NjordMojoSupport {
    @Parameter(required=true, property="from")
    private String from;
    @Parameter(required=true, property="to")
    private String to;
    @Parameter(required=true, property="drop", defaultValue="true")
    private boolean drop;

    @Override
    protected void doWithSession(Session ns) throws IOException {
        Optional fromOptional = ns.artifactStoreManager().selectArtifactStore(this.from);
        Optional toOptional = ns.artifactStoreManager().selectArtifactStore(this.to);
        if (!fromOptional.isPresent()) {
            this.logger.warn("ArtifactStore with given name not found: {}", (Object)this.from);
            return;
        }
        if (!toOptional.isPresent()) {
            this.logger.warn("ArtifactStore with given name not found: {}", (Object)this.to);
            return;
        }
        ns.artifactStoreMerger().redeploy((ArtifactStore)fromOptional.orElseThrow(J8Utils.OET), (ArtifactStore)toOptional.orElseThrow(J8Utils.OET));
        if (this.drop) {
            this.logger.info("Dropping {}", (Object)this.from);
            ns.artifactStoreManager().dropArtifactStore(this.from);
        }
    }
}

