/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.plugin3;

import eu.maveniverse.maven.njord.plugin3.PublisherSupportMojo;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.impl.J8Utils;
import eu.maveniverse.maven.njord.shared.publisher.ArtifactStorePublisher;
import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import eu.maveniverse.maven.njord.shared.store.ArtifactStoreTemplate;
import eu.maveniverse.maven.njord.shared.store.RepositoryMode;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;

@Mojo(name="status", threadSafe=true, aggregator=true)
public class StatusMojo
extends PublisherSupportMojo {
    @Override
    protected void doWithSession(Session ns) throws IOException, MojoFailureException {
        MavenProject cp = this.mavenSession.getTopLevelProject();
        if (cp.getDistributionManagement() == null) {
            this.logger.warn("No distribution management for project {}", (Object)cp.getName());
            throw new MojoFailureException("No distribution management found");
        }
        RemoteRepository deploymentRelease = new RemoteRepository.Builder(cp.getDistributionManagement().getRepository().getId(), "default", cp.getDistributionManagement().getRepository().getUrl()).setSnapshotPolicy(new RepositoryPolicy(false, null, null)).build();
        RemoteRepository deploymentSnapshot = new RemoteRepository.Builder(cp.getDistributionManagement().getSnapshotRepository().getId(), "default", cp.getDistributionManagement().getSnapshotRepository().getUrl()).setReleasePolicy(new RepositoryPolicy(false, null, null)).build();
        String deploymentReleaseUrl = ns.artifactPublisherRedirector().getRepositoryUrl(deploymentRelease, RepositoryMode.RELEASE);
        String deploymentSnapshotUrl = ns.artifactPublisherRedirector().getRepositoryUrl(deploymentSnapshot, RepositoryMode.SNAPSHOT);
        this.logger.info("Project deployment:");
        if (ns.config().prefix().isPresent()) {
            this.logger.info("  Store prefix: {}", ns.config().prefix().orElseThrow(J8Utils.OET));
        }
        this.logger.info("* Release");
        this.logger.info("  Repository Id: {}", (Object)deploymentRelease.getId());
        RemoteRepository releaseAuthSource = ns.artifactPublisherRedirector().getPublishingRepository(deploymentRelease, false, true);
        if (!Objects.equals(releaseAuthSource.getId(), deploymentRelease.getId())) {
            this.logger.info("  Auth source Id: {}", (Object)releaseAuthSource.getId());
        }
        if (releaseAuthSource.getAuthentication() != null) {
            this.logger.info("  Repository Auth: Present");
        } else {
            this.logger.warn("  Repository Auth: Absent");
        }
        this.logger.info("  POM URL: {}", (Object)deploymentRelease.getUrl());
        if (!Objects.equals(deploymentRelease.getUrl(), deploymentReleaseUrl)) {
            this.logger.info("  Effective URL: {}", (Object)deploymentReleaseUrl);
            if (deploymentReleaseUrl.startsWith("njord:")) {
                ArtifactStoreTemplate template = ns.selectSessionArtifactStoreTemplate(deploymentReleaseUrl.substring("njord:".length()));
                this.printTemplate(template, false);
            }
        }
        this.logger.info("* Snapshot");
        this.logger.info("  Repository Id: {}", (Object)deploymentSnapshot.getId());
        RemoteRepository snapshotAuthSource = ns.artifactPublisherRedirector().getPublishingRepository(deploymentSnapshot, false, true);
        if (!Objects.equals(snapshotAuthSource.getId(), deploymentSnapshot.getId())) {
            this.logger.info("  Auth source Id: {}", (Object)snapshotAuthSource.getId());
        }
        if (snapshotAuthSource.getAuthentication() != null) {
            this.logger.info("  Repository Auth: Present");
        } else {
            this.logger.warn("  Repository Auth: Absent");
        }
        this.logger.info("  POM URL: {}", (Object)deploymentSnapshot.getUrl());
        if (!Objects.equals(deploymentSnapshot.getUrl(), deploymentSnapshotUrl)) {
            this.logger.info("  Effective URL: {}", (Object)deploymentSnapshotUrl);
            if (deploymentSnapshotUrl.startsWith("njord:")) {
                ArtifactStoreTemplate template = ns.selectSessionArtifactStoreTemplate(deploymentSnapshotUrl.substring("njord:".length()));
                this.printTemplate(template, false);
            }
        }
        this.logger.info("");
        List<String> storeNameCandidates = this.getArtifactStoreNameCandidates(ns);
        if (storeNameCandidates.isEmpty()) {
            this.logger.info("No candidate artifact stores found");
        } else {
            this.logger.info("Locally staged stores:");
            for (String storeName : storeNameCandidates) {
                Optional aso = ns.artifactStoreManager().selectArtifactStore(storeName);
                if (!aso.isPresent()) continue;
                ArtifactStore artifactStore = (ArtifactStore)aso.orElseThrow(J8Utils.OET);
                try {
                    this.logger.info("  {}", (Object)artifactStore);
                }
                finally {
                    if (artifactStore == null) continue;
                    artifactStore.close();
                }
            }
        }
        this.logger.info("");
        Optional<String> pno = this.getArtifactStorePublisherName(ns);
        if (!pno.isPresent()) {
            this.logger.info("No configured publishers found");
        } else {
            this.logger.info("Project publishing:");
            String publisherName = pno.orElseThrow(J8Utils.OET);
            Optional po = ns.selectArtifactStorePublisher(publisherName);
            if (po.isPresent()) {
                this.printPublisher((ArtifactStorePublisher)po.orElseThrow(J8Utils.OET));
            } else {
                this.logger.warn("Unknown publisher set: {}", (Object)publisherName);
            }
        }
        this.logger.info("");
    }
}

