/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.plugin3;

import eu.maveniverse.maven.njord.plugin3.PublisherSupportMojo;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.impl.J8Utils;
import eu.maveniverse.maven.njord.shared.publisher.ArtifactStorePublisher;
import eu.maveniverse.maven.njord.shared.publisher.ArtifactStoreValidator;
import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import java.io.IOException;
import java.util.Optional;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="validate", threadSafe=true, requiresProject=false, aggregator=true)
public class ValidateMojo
extends PublisherSupportMojo {
    @Parameter(required=true, property="details", defaultValue="false")
    private boolean details;
    @Parameter(required=true, property="full", defaultValue="false")
    private boolean full;

    @Override
    protected void doWithSession(Session ns) throws IOException, MojoFailureException {
        ArtifactStorePublisher p = this.getArtifactStorePublisher(ns);
        try (ArtifactStore from = this.getArtifactStore(ns);){
            Optional vro = p.validate(from);
            if (vro.isPresent()) {
                this.logger.info("Validated {} against {}", (Object)from, (Object)p.name());
                ArtifactStoreValidator.ValidationResult vr = (ArtifactStoreValidator.ValidationResult)vro.orElseThrow(J8Utils.OET);
                if (this.details) {
                    this.logger.info("Validation results for {}", (Object)from.name());
                    this.dumpValidationResult("", vr, this.full);
                }
                if (!vr.isValid()) {
                    this.logger.error("ArtifactStore {} failed validation", (Object)from);
                    throw new MojoFailureException("ArtifactStore validation failed");
                }
                int warnings = vr.warningCount();
                if (warnings > 0) {
                    this.logger.warn("ArtifactStore {} passed {} validation with {} warnings", new Object[]{from, vr.checkCount(), warnings});
                } else {
                    this.logger.info("ArtifactStore {} passed {} validation", (Object)from, (Object)vr.checkCount());
                }
            } else {
                this.logger.info("No applicable validator for {} set in publisher {}; validation skipped", (Object)from, (Object)p.name());
            }
        }
    }

    private void dumpValidationResult(String prefix, ArtifactStoreValidator.ValidationResult vr, boolean full) {
        if (full) {
            this.logger.info("{} {}", (Object)prefix, (Object)vr.name());
            if (!vr.error().isEmpty()) {
                for (String msg : vr.error()) {
                    this.logger.error("{}    {}", (Object)prefix, (Object)msg);
                }
            }
            if (!vr.warning().isEmpty()) {
                for (String msg : vr.warning()) {
                    this.logger.warn("{}    {}", (Object)prefix, (Object)msg);
                }
            }
            if (!vr.info().isEmpty()) {
                for (String msg : vr.info()) {
                    this.logger.info("{}    {}", (Object)prefix, (Object)msg);
                }
            }
        } else if (vr.isValid()) {
            if (!vr.children().isEmpty()) {
                this.logger.info("{} {} OK", (Object)prefix, (Object)vr.name());
            }
        } else {
            this.logger.info("{} {}", (Object)prefix, (Object)vr.name());
            if (!vr.error().isEmpty()) {
                for (String msg : vr.error()) {
                    this.logger.error("{}    {}", (Object)prefix, (Object)msg);
                }
            }
            if (!vr.warning().isEmpty()) {
                for (String msg : vr.warning()) {
                    this.logger.warn("{}    {}", (Object)prefix, (Object)msg);
                }
            }
        }
        for (ArtifactStoreValidator.ValidationResult child : vr.children()) {
            this.dumpValidationResult(prefix + "  ", child, full);
        }
    }
}

