/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.njord.plugin3;

import eu.maveniverse.maven.njord.plugin3.NjordMojoSupport;
import eu.maveniverse.maven.njord.shared.Session;
import eu.maveniverse.maven.njord.shared.impl.J8Utils;
import eu.maveniverse.maven.njord.shared.store.ArtifactStore;
import eu.maveniverse.maven.shared.core.fs.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="write", threadSafe=true, requiresProject=false, aggregator=true)
public class WriteMojo
extends NjordMojoSupport {
    @Parameter(required=true, property="store")
    private String store;
    @Parameter(required=true, property="directory")
    private String directory;

    @Override
    protected void doWithSession(Session ns) throws IOException, MojoExecutionException {
        Optional storeOptional = ns.artifactStoreManager().selectArtifactStore(this.store);
        if (storeOptional.isPresent()) {
            Path targetDirectory = FileUtils.canonicalPath((Path)Paths.get(this.directory, new String[0]).toAbsolutePath());
            if (Files.exists(targetDirectory, new LinkOption[0])) {
                throw new MojoExecutionException("Exporting to existing directory not supported");
            }
            this.logger.info("Writing store {} as directory to {}", (Object)this.store, (Object)this.directory);
            Path result = ns.artifactStoreWriter().writeAsDirectory((ArtifactStore)storeOptional.orElseThrow(J8Utils.OET), targetDirectory);
            this.logger.info("Written to " + result);
        } else {
            this.logger.warn("ArtifactStore with given name not found");
        }
    }
}

