/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin;

import eu.maveniverse.maven.toolbox.plugin.MavenReactorLocator;
import eu.maveniverse.maven.toolbox.plugin.MojoSupport;
import eu.maveniverse.maven.toolbox.shared.DependencyMatcher;
import eu.maveniverse.maven.toolbox.shared.ReactorLocator;
import eu.maveniverse.maven.toolbox.shared.ResolutionRoot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;

public abstract class MPMojoSupport
extends MojoSupport {
    @Component
    protected MavenSession mavenSession;
    @Component
    protected MavenProject mavenProject;
    @Component
    protected ArtifactHandlerManager artifactHandlerManager;
    @Parameter(property="toolbox.search.backend.type")
    private String repositoryVendor;

    protected String getRepositoryVendor() {
        if (this.repositoryVendor != null) {
            return this.repositoryVendor;
        }
        return this.mavenProject.getProperties().getProperty("toolbox.search.backend.type");
    }

    protected List<Dependency> toDependencies(List<org.apache.maven.model.Dependency> dependencies) {
        ArtifactTypeRegistry artifactTypeRegistry = this.mavenSession.getRepositorySession().getArtifactTypeRegistry();
        return dependencies.stream().map(d -> RepositoryUtils.toDependency((org.apache.maven.model.Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList());
    }

    protected ResolutionRoot projectAsResolutionRoot() {
        return this.projectAsResolutionRoot(true);
    }

    protected ResolutionRoot projectAsResolutionRoot(boolean effective) {
        ResolutionRoot.Builder builder = ResolutionRoot.ofNotLoaded((Artifact)new DefaultArtifact(this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), this.artifactHandlerManager.getArtifactHandler(this.mavenProject.getPackaging()).getExtension(), this.mavenProject.getVersion()));
        if (effective) {
            builder.withDependencies(this.toDependencies(this.mavenProject.getDependencies()));
            if (this.mavenProject.getDependencyManagement() != null) {
                builder.withManagedDependencies(this.toDependencies(this.mavenProject.getDependencyManagement().getDependencies()));
            }
        } else {
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            Function<String, String> projectInterpolator = this.projectInterpolator();
            for (org.apache.maven.model.Dependency dependency : this.mavenProject.getOriginalModel().getDependencies()) {
                dependencies.add(new Dependency((Artifact)new DefaultArtifact(projectInterpolator.apply(this.mavenDependencyToGavString(dependency))), dependency.getScope()));
            }
            builder.withDependencies(dependencies);
            if (this.mavenProject.getOriginalModel().getDependencyManagement() != null) {
                ArrayList<Dependency> managedDependencies = new ArrayList<Dependency>();
                for (org.apache.maven.model.Dependency dependency : this.mavenProject.getOriginalModel().getDependencyManagement().getDependencies()) {
                    managedDependencies.add(new Dependency((Artifact)new DefaultArtifact(projectInterpolator.apply(this.mavenDependencyToGavString(dependency))), dependency.getScope()));
                }
                builder.withManagedDependencies(managedDependencies);
            }
        }
        return builder.build();
    }

    private String mavenDependencyToGavString(org.apache.maven.model.Dependency dependency) {
        return dependency.getClassifier() == null || dependency.getClassifier().isBlank() ? dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + this.artifactHandlerManager.getArtifactHandler(dependency.getType()).getExtension() + ":" + dependency.getVersion() : dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getClassifier() + ":" + this.artifactHandlerManager.getArtifactHandler(dependency.getType()).getExtension() + ":" + dependency.getVersion();
    }

    protected List<ResolutionRoot> projectManagedDependenciesAsResolutionRoots(boolean effective, DependencyMatcher dependencyMatcher) {
        ResolutionRoot project = this.projectAsResolutionRoot(effective);
        return project.getManagedDependencies().stream().filter(d -> !this.isReactorProject(d.getArtifact())).filter((Predicate<Dependency>)dependencyMatcher).map(d -> ResolutionRoot.ofLoaded((Artifact)this.getToolboxCommando().toArtifact(d)).build()).collect(Collectors.toList());
    }

    protected List<ResolutionRoot> projectDependenciesAsResolutionRoots(DependencyMatcher dependencyMatcher) {
        ResolutionRoot project = this.projectAsResolutionRoot();
        return project.getDependencies().stream().filter(d -> !this.isReactorProject(d.getArtifact())).filter((Predicate<Dependency>)dependencyMatcher).map(d -> ResolutionRoot.ofLoaded((Artifact)this.getToolboxCommando().toArtifact(d)).withManagedDependencies(project.getManagedDependencies()).applyManagedDependencies(true).cutDependencies(d.getOptional() != null && d.getOptional() != false || "provided".equals(d.getScope())).build()).collect(Collectors.toList());
    }

    protected boolean isReactorProject(Artifact artifact) {
        return this.mavenSession.getAllProjects().stream().anyMatch(p -> Objects.equals(p.getGroupId(), artifact.getGroupId()) && Objects.equals(p.getArtifactId(), artifact.getArtifactId()) && Objects.equals(p.getVersion(), artifact.getVersion()));
    }

    protected ReactorLocator getReactorLocator(String selector) {
        return new MavenReactorLocator(this.mavenSession, selector);
    }

    protected Function<String, String> projectInterpolator() {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.addValueSource((ValueSource)new PropertiesBasedValueSource(this.mavenProject.getProperties()));
        HashMap<String, String> projectAttributes = new HashMap<String, String>();
        projectAttributes.put("project.groupId", this.mavenProject.getGroupId());
        projectAttributes.put("project.artifactId", this.mavenProject.getArtifactId());
        projectAttributes.put("project.version", this.mavenProject.getVersion());
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(projectAttributes));
        return arg_0 -> MPMojoSupport.lambda$projectInterpolator$6((Interpolator)interpolator, arg_0);
    }

    private static /* synthetic */ String lambda$projectInterpolator$6(Interpolator interpolator, String s) {
        try {
            return interpolator.interpolate(s);
        }
        catch (InterpolationException e) {
            throw new IllegalStateException(e);
        }
    }
}

