/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin;

import eu.maveniverse.maven.toolbox.shared.ProjectLocator;
import eu.maveniverse.maven.toolbox.shared.ReactorLocator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

public class MavenReactorLocator
implements ReactorLocator {
    private final ReactorLocator.ReactorProject topLevel;
    private final ReactorLocator.ReactorProject current;
    private final ReactorLocator.ReactorProject selected;
    private final List<ReactorLocator.ReactorProject> allProjects;

    public MavenReactorLocator(MavenSession session, String selector) {
        Objects.requireNonNull(session, "session");
        this.allProjects = session.getAllProjects().stream().map(p -> this.convert(session.getRepositorySession(), (MavenProject)p)).collect(Collectors.toList());
        this.topLevel = this.locateProject(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)session.getTopLevelProject().getArtifact())).orElseThrow();
        this.current = this.locateProject(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)session.getCurrentProject().getArtifact())).orElseThrow();
        if (selector != null) {
            List<MavenProject> candidates = session.getAllProjects().stream().filter(this.createSelector(selector)).toList();
            if (candidates.size() != 1) {
                List<String> matches = candidates.stream().map(p -> ArtifactIdUtils.toId((Artifact)RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)p.getArtifact()))).toList();
                throw new IllegalArgumentException("Could not find 1 matching project: " + String.valueOf(matches));
            }
            this.selected = this.locateProject(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)candidates.get(0).getArtifact())).orElseThrow();
        } else {
            this.selected = null;
        }
    }

    private Predicate<MavenProject> createSelector(String selector) {
        String[] elems = (String[])Arrays.stream(selector.split(":", -1)).filter(s -> !s.isEmpty()).toArray(String[]::new);
        if (selector.startsWith(":")) {
            if (elems.length == 1) {
                return p -> p.getArtifactId().equals(elems[0]);
            }
            if (elems.length == 2) {
                return p -> p.getArtifactId().equals(elems[0]) && p.getVersion().equals(elems[1]);
            }
        } else {
            if (elems.length == 2) {
                return p -> p.getGroupId().equals(elems[0]) && p.getArtifactId().equals(elems[1]);
            }
            if (elems.length == 3) {
                return p -> p.getGroupId().equals(elems[0]) && p.getArtifactId().equals(elems[1]) && p.getVersion().equals(elems[2]);
            }
        }
        throw new IllegalArgumentException("Unsupported selector expression: '" + selector + "'");
    }

    private ReactorLocator.ReactorProject convert(RepositorySystemSession session, MavenProject project) {
        Objects.requireNonNull(project, "project");
        Artifact pa = RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)project.getArtifact());
        DefaultArtifact pp = null;
        if (project.getModel().getParent() != null) {
            Parent parent = project.getModel().getParent();
            pp = new DefaultArtifact(parent.getGroupId(), parent.getArtifactId(), "pom", parent.getVersion());
        }
        List<Dependency> pd = project.getModel().getDependencies().stream().map(d -> RepositoryUtils.toDependency((org.apache.maven.model.Dependency)d, (ArtifactTypeRegistry)session.getArtifactTypeRegistry())).collect(Collectors.toList());
        List<Artifact> collected = project.getCollectedProjects().stream().map(p -> RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)p.getArtifact())).collect(Collectors.toList());
        return new MProject(pa, (Artifact)pp, pd, collected, (ProjectLocator)this, project.getModel());
    }

    public ReactorLocator.ReactorProject getTopLevelProject() {
        return this.topLevel;
    }

    public Optional<ReactorLocator.ReactorProject> getSelectedProject() {
        return Optional.ofNullable(this.selected);
    }

    public ReactorLocator.ReactorProject getCurrentProject() {
        return this.current;
    }

    public List<ReactorLocator.ReactorProject> getAllProjects() {
        return this.allProjects;
    }

    public Optional<ReactorLocator.ReactorProject> locateProject(Artifact artifact) {
        return this.allProjects.stream().filter(p -> ArtifactIdUtils.equalsId((Artifact)p.artifact(), (Artifact)artifact)).findFirst();
    }

    public List<ReactorLocator.ReactorProject> locateChildren(ProjectLocator.Project project) {
        return this.allProjects.stream().filter(p -> {
            Optional parentArtifact = p.getParent();
            return parentArtifact.isPresent() && ArtifactIdUtils.equalsId((Artifact)((Artifact)parentArtifact.orElseThrow()), (Artifact)project.artifact());
        }).collect(Collectors.toList());
    }

    public List<ReactorLocator.ReactorProject> locateCollected(ProjectLocator.Project project) {
        if (project instanceof MProject) {
            MProject mProject = (MProject)project;
            List allOfGrandchildren = mProject.collected().stream().map(this::locateProject).filter(Optional::isPresent).map(Optional::get).filter(p -> MProject.class.isAssignableFrom(p.getClass())).map(p -> ((MProject)p).collected()).flatMap(Collection::stream).map(this::locateProject).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            return mProject.collected().stream().map(this::locateProject).filter(Optional::isPresent).map(Optional::get).toList().stream().filter(p -> !allOfGrandchildren.contains(p)).collect(Collectors.toList());
        }
        return List.of();
    }

    public Stream<Artifact> get() {
        return this.getAllProjects().stream().map(ProjectLocator.Project::artifact);
    }

    private static final class MProject
    implements ReactorLocator.ReactorProject {
        private final Artifact artifact;
        private final Artifact parent;
        private final List<Dependency> dependencies;
        private final List<Artifact> collected;
        private final ProjectLocator origin;
        private final Model effectiveModel;

        private MProject(Artifact artifact, Artifact parent, List<Dependency> dependencies, List<Artifact> collected, ProjectLocator origin, Model effectiveModel) {
            this.artifact = Objects.requireNonNull(artifact, "artifact");
            this.parent = parent;
            this.dependencies = Objects.requireNonNull(dependencies, "dependencies");
            this.collected = Objects.requireNonNull(collected, "collected");
            this.origin = origin;
            this.effectiveModel = Objects.requireNonNull(effectiveModel, "effectiveModel");
        }

        public Optional<Artifact> getParent() {
            return Optional.ofNullable(this.parent);
        }

        public Artifact artifact() {
            return this.artifact;
        }

        public Artifact parent() {
            return this.parent;
        }

        public List<Dependency> dependencies() {
            return this.dependencies;
        }

        public List<Artifact> collected() {
            return this.collected;
        }

        public ProjectLocator origin() {
            return this.origin;
        }

        public Model effectiveModel() {
            return this.effectiveModel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MProject mProject = (MProject)o;
            return Objects.equals(this.artifact, mProject.artifact) && Objects.equals(this.parent, mProject.parent) && Objects.equals(this.dependencies, mProject.dependencies) && Objects.equals(this.collected, mProject.collected) && Objects.equals(this.origin, mProject.origin);
        }

        public int hashCode() {
            return Objects.hash(this.artifact, this.parent, this.dependencies, this.collected, this.origin);
        }
    }
}

