/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.Runtime;
import eu.maveniverse.maven.mima.context.Runtimes;
import eu.maveniverse.maven.toolbox.plugin.ContextMapAware;
import eu.maveniverse.maven.toolbox.plugin.CwdAware;
import eu.maveniverse.maven.toolbox.plugin.OutputFactory;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommandoVersion;
import eu.maveniverse.maven.toolbox.shared.input.StringSlurper;
import eu.maveniverse.maven.toolbox.shared.output.Output;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import picocli.CommandLine;

public abstract class MojoSupport
extends AbstractMojo
implements Callable<Integer>,
CwdAware,
ContextMapAware,
CommandLine.IVersionProvider {
    @CommandLine.Option(names={"--verbosity"}, defaultValue="NORMAL", description={"Output verbosity level in CLI. Accepted values: SILENT, TIGHT, NORMAL (default), SUGGEST, CHATTER"})
    @Parameter(property="verbosity", defaultValue="NORMAL")
    private Output.Verbosity verbosity;
    @CommandLine.Option(names={"-X", "--debug"}, description={"Enable debug logging in CLI."})
    private boolean debug;
    @CommandLine.Option(names={"-Y", "--trace"}, description={"Enable trace logging in CLI."})
    private boolean trace;
    @CommandLine.Option(names={"-o", "--offline"}, description={"Work offline"})
    private boolean offline;
    @CommandLine.Option(names={"-s", "--settings"}, description={"The Maven User Settings file to use"})
    private Path userSettingsXml;
    @CommandLine.Option(names={"-gs", "--global-settings"}, description={"The Maven Global Settings file to use"})
    private Path globalSettingsXml;
    @CommandLine.Option(names={"-P", "--activate-profiles"}, split=",", description={"Comma delimited list of profile IDs to activate (may use '+', '-' and '!' prefix)"})
    private List<String> profiles;
    @CommandLine.Option(names={"-D", "--define"}, description={"Define a user property"})
    private List<String> userProperties;
    @CommandLine.Option(names={"--proxy"}, description={"Define a HTTP proxy (host:port)"})
    private String proxy;
    @CommandLine.Option(names={"-B", "--batch-mode"}, defaultValue="false", description={"Work in batch mode (do not use ANSI colors)"})
    private boolean batch;
    @CommandLine.Option(names={"-e", "--errors"}, defaultValue="false", description={"Show error stack traces"})
    private boolean errors;
    @CommandLine.Option(names={"--fail-on-logical-failure"}, defaultValue="true", description={"Fail on operation logical failure"})
    @Parameter(property="failOnLogicalFailure", defaultValue="true")
    private boolean failOnLogicalFailure;
    @CommandLine.Option(names={"--extra-repositories"}, description={"Appends extra repositories to context."})
    @Parameter(property="extraRepositories")
    private String extraRepositories;
    private Path cwd = Path.of(System.getProperty("user.dir"), new String[0]);
    private final AtomicReference<Map<Object, Object>> contextMapRef = new AtomicReference<Object>(null);
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings mojoSettings;
    @Parameter(defaultValue="${session.request.interactiveMode}", readonly=true, required=true)
    protected boolean mojoInteractiveMode;
    @Parameter(defaultValue="${session.request.showErrors}", readonly=true, required=true)
    protected boolean mojoErrors;
    @Parameter(property="forceStdout")
    protected boolean forceStdout;
    @CommandLine.Option(names={"--dry-run"}, defaultValue="false", description={"Option to run potentially destructive commands without performing any IO"})
    @Parameter(property="dryRun", defaultValue="false")
    protected boolean dryRun;

    @Override
    public void setCwd(Path cwd) {
        Objects.requireNonNull(cwd, "cwd");
        if (!Files.isDirectory(cwd, new LinkOption[0])) {
            throw new IllegalArgumentException("cwd must be an existing directory");
        }
        this.cwd = cwd;
    }

    @Override
    public Optional<Path> getCwd() {
        return Optional.of(this.cwd);
    }

    @Override
    public void setContextMap(Map<Object, Object> context) {
        Objects.requireNonNull(context, "context map");
        if (!this.contextMapRef.compareAndSet(null, context)) {
            throw new IllegalStateException("context map already set");
        }
    }

    @Override
    public Optional<Map<Object, Object>> getContextMap() {
        return Optional.ofNullable(this.contextMapRef.get());
    }

    protected <T> T getOrCreate(Class<T> key, Supplier<T> supplier) {
        return (T)this.contextMapRef.get().computeIfAbsent(key, k -> supplier.get());
    }

    protected <T> T get(Class<T> key) {
        return (T)Objects.requireNonNull(this.contextMapRef.get().get(key), "key is not present");
    }

    protected <T> void set(Class<T> key, T value) {
        Objects.requireNonNull(key, "key");
        if (value == null) {
            this.contextMapRef.get().remove(key);
        } else {
            this.contextMapRef.get().put(key, value);
        }
    }

    public String[] getVersion() {
        return new String[]{"MIMA " + Runtimes.INSTANCE.getRuntime().version(), "Toolbox " + ToolboxCommandoVersion.getVersion()};
    }

    private ContextOverrides createCLIContextOverrides() {
        ContextOverrides.Builder builder = ContextOverrides.create().withUserSettings(true);
        if (this.cwd != null) {
            builder.withBasedirOverride(this.cwd);
        }
        if (this.offline) {
            builder.offline(Boolean.valueOf(true));
        }
        if (this.userSettingsXml != null) {
            builder.withUserSettingsXmlOverride(this.userSettingsXml);
        }
        if (this.globalSettingsXml != null) {
            builder.withGlobalSettingsXmlOverride(this.globalSettingsXml);
        }
        if (this.profiles != null && !this.profiles.isEmpty()) {
            ArrayList<String> activeProfiles = new ArrayList<String>();
            ArrayList<String> inactiveProfiles = new ArrayList<String>();
            for (String profile : this.profiles) {
                if (profile.startsWith("+")) {
                    activeProfiles.add(profile.substring(1));
                    continue;
                }
                if (profile.startsWith("-") || profile.startsWith("!")) {
                    inactiveProfiles.add(profile.substring(1));
                    continue;
                }
                activeProfiles.add(profile);
            }
            builder.withActiveProfileIds(activeProfiles).withInactiveProfileIds(inactiveProfiles);
        }
        if (this.userProperties != null && !this.userProperties.isEmpty()) {
            HashMap<String, String> defined = new HashMap<String, String>(this.userProperties.size());
            for (String property : this.userProperties) {
                String value;
                String name;
                int i = property.indexOf(61);
                if (i <= 0) {
                    name = property.trim();
                    value = Boolean.TRUE.toString();
                } else {
                    name = property.substring(0, i).trim();
                    value = property.substring(i + 1);
                }
                defined.put(name, value);
            }
            builder.userProperties(defined);
        }
        if (this.proxy != null) {
            String[] elems = this.proxy.split(":");
            if (elems.length != 2) {
                throw new IllegalArgumentException("Proxy must be specified as 'host:port'");
            }
            Proxy proxySettings = new Proxy();
            proxySettings.setId("mima-mixin");
            proxySettings.setActive(true);
            proxySettings.setProtocol("http");
            proxySettings.setHost(elems[0]);
            proxySettings.setPort(Integer.parseInt(elems[1]));
            Settings proxyMixin = new Settings();
            proxyMixin.addProxy(proxySettings);
            builder.withEffectiveSettingsMixin((Object)proxyMixin);
        }
        return builder.build();
    }

    private ContextOverrides createMojoContextOverrides() {
        ContextOverrides.Builder contextOverrides = ContextOverrides.create();
        if (this.cwd != null) {
            contextOverrides.withBasedirOverride(this.cwd);
        }
        return contextOverrides.build();
    }

    protected Context getContext() {
        return this.get(Context.class);
    }

    protected Output getOutput() {
        return this.get(Output.class);
    }

    protected ToolboxCommando getToolboxCommando() {
        return Objects.requireNonNull(this.get(ToolboxCommando.class), "toolbox not initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Integer call() {
        if (this.trace) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "TRACE");
        } else if (this.debug) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "DEBUG");
        }
        boolean seeded = this.contextMapRef.compareAndSet(null, new HashMap());
        this.getOrCreate(Runtime.class, () -> ((Runtimes)Runtimes.INSTANCE).getRuntime());
        this.getOrCreate(Context.class, () -> this.get(Runtime.class).create(this.createCLIContextOverrides()));
        this.getOrCreate(Output.class, () -> OutputFactory.createCliOutput(this.batch, this.errors, this.verbosity));
        ToolboxCommando commando = this.getOrCreate(ToolboxCommando.class, () -> ToolboxCommando.create((Output)this.getOutput(), (Context)this.getContext()));
        ToolboxCommando customized = null;
        if (this.extraRepositories != null) {
            customized = commando.withContextOverrides(this.getContext().contextOverrides().toBuilder().addRepositoriesOp(ContextOverrides.AddRepositoriesOp.APPEND).repositories(StringSlurper.csv((String)this.extraRepositories).stream().map(arg_0 -> ((ToolboxCommando)commando).parseRemoteRepository(arg_0)).toList()).build());
            this.set(ToolboxCommando.class, customized);
        } else {
            this.set(ToolboxCommando.class, commando);
        }
        try {
            Result<?> result = this.doExecute();
            if (!result.isSuccess() && this.failOnLogicalFailure) {
                Integer n = 1;
                return n;
            }
            Integer n = 0;
            return n;
        }
        catch (RuntimeException e) {
            System.err.println("Error: " + String.valueOf(e.getClass()) + ": " + e.getMessage());
            e.printStackTrace(System.err);
            Integer n = 1;
            return n;
        }
        catch (Exception e) {
            System.err.println("Error: " + String.valueOf(e.getClass()) + ": " + e.getMessage());
            if (this.errors) {
                e.printStackTrace(System.err);
            }
            Integer n = 1;
            return n;
        }
        finally {
            if (customized != null) {
                this.getToolboxCommando().close();
                this.set(ToolboxCommando.class, commando);
            }
            if (seeded) {
                try {
                    this.getOutput().close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                try {
                    this.getContext().close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                this.contextMapRef.set(null);
            }
        }
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        boolean seeded = this.contextMapRef.compareAndSet(null, new HashMap());
        this.getOrCreate(Runtime.class, () -> ((Runtimes)Runtimes.INSTANCE).getRuntime());
        this.getOrCreate(Context.class, () -> this.get(Runtime.class).create(this.createMojoContextOverrides()));
        if (this.forceStdout) {
            this.getOrCreate(Output.class, () -> OutputFactory.createCliOutput(!this.mojoInteractiveMode, this.mojoErrors, this.verbosity));
        } else {
            this.getOrCreate(Output.class, () -> OutputFactory.createMojoOutput(!this.mojoInteractiveMode, this.mojoErrors, this.verbosity));
        }
        ToolboxCommando commando = this.getOrCreate(ToolboxCommando.class, () -> ToolboxCommando.create((Output)this.getOutput(), (Context)this.getContext()));
        ToolboxCommando customized = null;
        if (this.extraRepositories != null) {
            customized = commando.withContextOverrides(this.getContext().contextOverrides().toBuilder().addRepositoriesOp(ContextOverrides.AddRepositoriesOp.APPEND).repositories(StringSlurper.csv((String)this.extraRepositories).stream().map(arg_0 -> ((ToolboxCommando)commando).parseRemoteRepository(arg_0)).toList()).build());
            this.set(ToolboxCommando.class, customized);
        } else {
            this.set(ToolboxCommando.class, commando);
        }
        try {
            Result<?> result = this.doExecute();
            if (!result.isSuccess() && this.failOnLogicalFailure) {
                throw new MojoFailureException("Operation failed: " + result.getMessage());
            }
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("Execution failed: ", (Exception)e);
        }
        catch (Exception e) {
            throw new MojoFailureException("Operation failed: ", (Throwable)e);
        }
        finally {
            if (customized != null) {
                this.getToolboxCommando().close();
                this.set(ToolboxCommando.class, commando);
            }
            if (seeded) {
                try {
                    this.getOutput().close();
                }
                catch (Exception e) {
                    this.getLog().error((Throwable)e);
                }
                try {
                    this.getContext().close();
                }
                catch (Exception e) {
                    this.getLog().error((Throwable)e);
                }
                this.contextMapRef.set(null);
            }
        }
    }

    protected abstract Result<?> doExecute() throws Exception;
}

