/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ArtifactDifferentiator;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.input.StringSlurper;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import picocli.CommandLine;

@CommandLine.Command(name="classpath-conflict", description={"Resolves two Maven Artifact and prints out the classpath conflicts"})
@Mojo(name="gav-classpath-conflict", requiresProject=false, threadSafe=true)
public class GavClasspathConflictMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The first GAV to compare classpath"})
    @Parameter(property="gav1", required=true)
    private String gav1;
    @CommandLine.Parameters(index="1", description={"The second GAV to compare classpath"})
    @Parameter(property="gav2", required=true)
    private String gav2;
    @CommandLine.Option(names={"--scope"}, defaultValue="runtime", description={"Resolution scope to resolve (default 'runtime')"})
    @Parameter(property="scope", defaultValue="runtime", required=true)
    private String scope;
    @CommandLine.Option(names={"--boms"}, defaultValue="", description={"Comma separated list of BOMs to apply"})
    @Parameter(property="boms")
    private String boms;
    @CommandLine.Option(names={"--keyFactorySpec"}, defaultValue="versionlessId()", description={"The artifact key factory to apply (defines sets of possibly conflicting artifacts)."})
    @Parameter(property="keyFactorySpec", defaultValue="versionlessId()", required=true)
    private String keyFactorySpec;
    @CommandLine.Option(names={"--artifactDifferentiatorSpec"}, defaultValue="majorVersion()", description={"The artifact differentiators to apply to set of conflicting artifacts. If differentiator comes up with more than one partition, you have a conflict."})
    @Parameter(property="artifactDifferentiatorSpec", defaultValue="majorVersion()", required=true)
    private String artifactDifferentiatorSpec;

    protected Result<Map<String, String>> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        HashMap<String, ArtifactDifferentiator> differentiators = new HashMap<String, ArtifactDifferentiator>();
        for (String differentiatorSpec : this.artifactDifferentiatorSpec.split(",")) {
            differentiators.put(differentiatorSpec, toolboxCommando.parseArtifactDifferentiatorSpec(differentiatorSpec));
        }
        return toolboxCommando.classpathConflict(ResolutionScope.parse((String)this.scope), toolboxCommando.loadGav(this.gav1, StringSlurper.slurp((String)this.boms)), toolboxCommando.loadGav(this.gav2, StringSlurper.slurp((String)this.boms)), toolboxCommando.parseArtifactKeyFactorySpec(this.keyFactorySpec), differentiators);
    }
}

