/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.input.StringSlurper;
import java.util.Map;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import picocli.CommandLine;

@CommandLine.Command(name="classpath-diff", description={"Resolves Maven Artifact and prints out the classpath"})
@Mojo(name="gav-classpath-diff", requiresProject=false, threadSafe=true)
public class GavClasspathDiffMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The first GAV to compare classpath"})
    @Parameter(property="gav1", required=true)
    private String gav1;
    @CommandLine.Parameters(index="1", description={"The second GAV to compare classpath"})
    @Parameter(property="gav2", required=true)
    private String gav2;
    @CommandLine.Option(names={"--scope"}, defaultValue="runtime", description={"Resolution scope to resolve (default 'runtime')"})
    @Parameter(property="scope", defaultValue="runtime", required=true)
    private String scope;
    @CommandLine.Option(names={"--boms"}, defaultValue="", description={"Comma separated list of BOMs to apply"})
    @Parameter(property="boms")
    private String boms;
    @CommandLine.Option(names={"--unified"}, defaultValue="false", description={"Make it true for unified diff"})
    @Parameter(property="unified", defaultValue="false", required=true)
    private boolean unified;

    protected Result<Map<String, String>> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        return toolboxCommando.classpathDiff(ResolutionScope.parse((String)this.scope), toolboxCommando.loadGav(this.gav1, StringSlurper.slurp((String)this.boms)), toolboxCommando.loadGav(this.gav2, StringSlurper.slurp((String)this.boms)), this.unified);
    }
}

