/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.toolbox.plugin.gav;

import eu.maveniverse.maven.toolbox.plugin.GavMojoSupport;
import eu.maveniverse.maven.toolbox.shared.ResolutionScope;
import eu.maveniverse.maven.toolbox.shared.Result;
import eu.maveniverse.maven.toolbox.shared.ToolboxCommando;
import eu.maveniverse.maven.toolbox.shared.input.StringSlurper;
import java.util.List;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import picocli.CommandLine;

@CommandLine.Command(name="classpath-list", description={"Resolves Maven Artifact and prints out the classpath as artifacts"})
@Mojo(name="gav-classpath-list", requiresProject=false, threadSafe=true)
public class GavClasspathListMojo
extends GavMojoSupport {
    @CommandLine.Parameters(index="0", description={"The GAV to print classpath for"})
    @Parameter(property="gav", required=true)
    private String gav;
    @CommandLine.Option(names={"--scope"}, defaultValue="runtime", description={"Resolution scope to resolve (default 'runtime')"})
    @Parameter(property="scope", defaultValue="runtime", required=true)
    private String scope;
    @CommandLine.Option(names={"--boms"}, defaultValue="", description={"Comma separated list of BOMs to apply"})
    @Parameter(property="boms")
    private String boms;
    @CommandLine.Option(names={"--details"}, defaultValue="false", description={"Make it true for details listed"})
    @Parameter(property="details", defaultValue="false", required=true)
    private boolean details;

    protected Result<List<Artifact>> doExecute() throws Exception {
        ToolboxCommando toolboxCommando = this.getToolboxCommando();
        return toolboxCommando.classpathList(ResolutionScope.parse((String)this.scope), toolboxCommando.loadGavs(StringSlurper.slurp((String)this.gav), StringSlurper.slurp((String)this.boms)), this.details);
    }
}

